@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceClientAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsName The name that you use in the applications of client tasks to connect to this service.
 * @property port The listening port number for the Service Connect proxy. This port is available inside of all of the tasks within the same namespace.
 */
public data class ServiceServiceConnectConfigurationServiceClientAliasArgs(
    public val dnsName: Output<String>? = null,
    public val port: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceClientAliasArgs> {
    override fun toJava():
        com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceClientAliasArgs =
        com.pulumi.aws.ecs.inputs.ServiceServiceConnectConfigurationServiceClientAliasArgs.builder()
            .dnsName(dnsName?.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceServiceConnectConfigurationServiceClientAliasArgs].
 */
@PulumiTagMarker
public class ServiceServiceConnectConfigurationServiceClientAliasArgsBuilder internal constructor() {
    private var dnsName: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The name that you use in the applications of client tasks to connect to this service.
     */
    @JvmName("iwciwetvmacptvfp")
    public suspend fun dnsName(`value`: Output<String>) {
        this.dnsName = value
    }

    /**
     * @param value The listening port number for the Service Connect proxy. This port is available inside of all of the tasks within the same namespace.
     */
    @JvmName("onvbdutojfilngbl")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The name that you use in the applications of client tasks to connect to this service.
     */
    @JvmName("jmvvkqqvqvqftjma")
    public suspend fun dnsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsName = mapped
    }

    /**
     * @param value The listening port number for the Service Connect proxy. This port is available inside of all of the tasks within the same namespace.
     */
    @JvmName("nrxxvwxsuofpaiod")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): ServiceServiceConnectConfigurationServiceClientAliasArgs =
        ServiceServiceConnectConfigurationServiceClientAliasArgs(
            dnsName = dnsName,
            port = port ?: throw PulumiNullFieldException("port"),
        )
}
