@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskDefinitionInferenceAcceleratorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName Elastic Inference accelerator device name. The deviceName must also be referenced in a container definition as a ResourceRequirement.
 * @property deviceType Elastic Inference accelerator type to use.
 */
public data class TaskDefinitionInferenceAcceleratorArgs(
    public val deviceName: Output<String>,
    public val deviceType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskDefinitionInferenceAcceleratorArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskDefinitionInferenceAcceleratorArgs =
        com.pulumi.aws.ecs.inputs.TaskDefinitionInferenceAcceleratorArgs.builder()
            .deviceName(deviceName.applyValue({ args0 -> args0 }))
            .deviceType(deviceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskDefinitionInferenceAcceleratorArgs].
 */
@PulumiTagMarker
public class TaskDefinitionInferenceAcceleratorArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var deviceType: Output<String>? = null

    /**
     * @param value Elastic Inference accelerator device name. The deviceName must also be referenced in a container definition as a ResourceRequirement.
     */
    @JvmName("oqrouinfuumepxre")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Elastic Inference accelerator type to use.
     */
    @JvmName("cdywqdicqxwnvgoo")
    public suspend fun deviceType(`value`: Output<String>) {
        this.deviceType = value
    }

    /**
     * @param value Elastic Inference accelerator device name. The deviceName must also be referenced in a container definition as a ResourceRequirement.
     */
    @JvmName("xqkmvyeribdncnpk")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Elastic Inference accelerator type to use.
     */
    @JvmName("ojkjboepcwkdvbls")
    public suspend fun deviceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceType = mapped
    }

    internal fun build(): TaskDefinitionInferenceAcceleratorArgs =
        TaskDefinitionInferenceAcceleratorArgs(
            deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
            deviceType = deviceType ?: throw PulumiNullFieldException("deviceType"),
        )
}
