@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskDefinitionPlacementConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expression Cluster Query Language expression to apply to the constraint. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
 * @property type Type of constraint. Use `memberOf` to restrict selection to a group of valid candidates. Note that `distinctInstance` is not supported in task definitions.
 */
public data class TaskDefinitionPlacementConstraintArgs(
    public val expression: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskDefinitionPlacementConstraintArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskDefinitionPlacementConstraintArgs =
        com.pulumi.aws.ecs.inputs.TaskDefinitionPlacementConstraintArgs.builder()
            .expression(expression?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskDefinitionPlacementConstraintArgs].
 */
@PulumiTagMarker
public class TaskDefinitionPlacementConstraintArgsBuilder internal constructor() {
    private var expression: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Cluster Query Language expression to apply to the constraint. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
     */
    @JvmName("arfmtdhlmqxmydtn")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value Type of constraint. Use `memberOf` to restrict selection to a group of valid candidates. Note that `distinctInstance` is not supported in task definitions.
     */
    @JvmName("wrdfwojlqtjuxofn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Cluster Query Language expression to apply to the constraint. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
     */
    @JvmName("bjaaudkinjqyegxs")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value Type of constraint. Use `memberOf` to restrict selection to a group of valid candidates. Note that `distinctInstance` is not supported in task definitions.
     */
    @JvmName("vxjpikfeckbaansv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TaskDefinitionPlacementConstraintArgs =
        TaskDefinitionPlacementConstraintArgs(
            expression = expression,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
