@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskDefinitionProxyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property containerName Name of the container that will serve as the App Mesh proxy.
 * @property properties Set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified a key-value mapping.
 * @property type Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
 */
public data class TaskDefinitionProxyConfigurationArgs(
    public val containerName: Output<String>,
    public val properties: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskDefinitionProxyConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskDefinitionProxyConfigurationArgs =
        com.pulumi.aws.ecs.inputs.TaskDefinitionProxyConfigurationArgs.builder()
            .containerName(containerName.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskDefinitionProxyConfigurationArgs].
 */
@PulumiTagMarker
public class TaskDefinitionProxyConfigurationArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Name of the container that will serve as the App Mesh proxy.
     */
    @JvmName("qnvdlxcpaahjpfhr")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified a key-value mapping.
     */
    @JvmName("mwnggubmmvycjyll")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
     */
    @JvmName("nclktpjelgtgkbig")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Name of the container that will serve as the App Mesh proxy.
     */
    @JvmName("tscqexwajelaqqrx")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified a key-value mapping.
     */
    @JvmName("rdrpcvyyultqpkrk")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified a key-value mapping.
     */
    @JvmName("iwxadjiaamcxjjhy")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
     */
    @JvmName("tixlvkqxpskqopla")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TaskDefinitionProxyConfigurationArgs = TaskDefinitionProxyConfigurationArgs(
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        properties = properties,
        type = type,
    )
}
