@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskDefinitionRuntimePlatformArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cpuArchitecture Must be set to either `X86_64` or `ARM64`; see [cpu architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform)
 * @property operatingSystemFamily If the `requires_compatibilities` is `FARGATE` this field is required; must be set to a valid option from the [operating system family in the runtime platform](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform) setting
 */
public data class TaskDefinitionRuntimePlatformArgs(
    public val cpuArchitecture: Output<String>? = null,
    public val operatingSystemFamily: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskDefinitionRuntimePlatformArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskDefinitionRuntimePlatformArgs =
        com.pulumi.aws.ecs.inputs.TaskDefinitionRuntimePlatformArgs.builder()
            .cpuArchitecture(cpuArchitecture?.applyValue({ args0 -> args0 }))
            .operatingSystemFamily(operatingSystemFamily?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskDefinitionRuntimePlatformArgs].
 */
@PulumiTagMarker
public class TaskDefinitionRuntimePlatformArgsBuilder internal constructor() {
    private var cpuArchitecture: Output<String>? = null

    private var operatingSystemFamily: Output<String>? = null

    /**
     * @param value Must be set to either `X86_64` or `ARM64`; see [cpu architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform)
     */
    @JvmName("cffwgtwrhqmdwcon")
    public suspend fun cpuArchitecture(`value`: Output<String>) {
        this.cpuArchitecture = value
    }

    /**
     * @param value If the `requires_compatibilities` is `FARGATE` this field is required; must be set to a valid option from the [operating system family in the runtime platform](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform) setting
     */
    @JvmName("tisljftxvcnkmhos")
    public suspend fun operatingSystemFamily(`value`: Output<String>) {
        this.operatingSystemFamily = value
    }

    /**
     * @param value Must be set to either `X86_64` or `ARM64`; see [cpu architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform)
     */
    @JvmName("bjgafihiedjuxqad")
    public suspend fun cpuArchitecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuArchitecture = mapped
    }

    /**
     * @param value If the `requires_compatibilities` is `FARGATE` this field is required; must be set to a valid option from the [operating system family in the runtime platform](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform) setting
     */
    @JvmName("dkuvhibmvtuuekbj")
    public suspend fun operatingSystemFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingSystemFamily = mapped
    }

    internal fun build(): TaskDefinitionRuntimePlatformArgs = TaskDefinitionRuntimePlatformArgs(
        cpuArchitecture = cpuArchitecture,
        operatingSystemFamily = operatingSystemFamily,
    )
}
