@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dockerVolumeConfiguration Configuration block to configure a docker volume. Detailed below.
 * @property efsVolumeConfiguration Configuration block for an EFS volume. Detailed below.
 * @property fsxWindowsFileServerVolumeConfiguration Configuration block for an FSX Windows File Server volume. Detailed below.
 * @property hostPath Path on the host container instance that is presented to the container. If not set, ECS will create a nonpersistent data volume that starts empty and is deleted after the task has finished.
 * @property name Name of the volume. This name is referenced in the `sourceVolume`
 * parameter of container definition in the `mountPoints` section.
 */
public data class TaskDefinitionVolumeArgs(
    public val dockerVolumeConfiguration: Output<TaskDefinitionVolumeDockerVolumeConfigurationArgs>? =
        null,
    public val efsVolumeConfiguration: Output<TaskDefinitionVolumeEfsVolumeConfigurationArgs>? = null,
    public val fsxWindowsFileServerVolumeConfiguration:
    Output<TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs>? = null,
    public val hostPath: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs =
        com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeArgs.builder()
            .dockerVolumeConfiguration(
                dockerVolumeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .efsVolumeConfiguration(
                efsVolumeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .fsxWindowsFileServerVolumeConfiguration(
                fsxWindowsFileServerVolumeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .hostPath(hostPath?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskDefinitionVolumeArgs].
 */
@PulumiTagMarker
public class TaskDefinitionVolumeArgsBuilder internal constructor() {
    private var dockerVolumeConfiguration: Output<TaskDefinitionVolumeDockerVolumeConfigurationArgs>? =
        null

    private var efsVolumeConfiguration: Output<TaskDefinitionVolumeEfsVolumeConfigurationArgs>? = null

    private var fsxWindowsFileServerVolumeConfiguration:
        Output<TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs>? = null

    private var hostPath: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Configuration block to configure a docker volume. Detailed below.
     */
    @JvmName("eklkwrtbcrohvpih")
    public suspend
    fun dockerVolumeConfiguration(`value`: Output<TaskDefinitionVolumeDockerVolumeConfigurationArgs>) {
        this.dockerVolumeConfiguration = value
    }

    /**
     * @param value Configuration block for an EFS volume. Detailed below.
     */
    @JvmName("nnijntkrqtaosqgo")
    public suspend
    fun efsVolumeConfiguration(`value`: Output<TaskDefinitionVolumeEfsVolumeConfigurationArgs>) {
        this.efsVolumeConfiguration = value
    }

    /**
     * @param value Configuration block for an FSX Windows File Server volume. Detailed below.
     */
    @JvmName("byucktccrubqhylj")
    public suspend
    fun fsxWindowsFileServerVolumeConfiguration(`value`: Output<TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs>) {
        this.fsxWindowsFileServerVolumeConfiguration = value
    }

    /**
     * @param value Path on the host container instance that is presented to the container. If not set, ECS will create a nonpersistent data volume that starts empty and is deleted after the task has finished.
     */
    @JvmName("cucbukyublaffejs")
    public suspend fun hostPath(`value`: Output<String>) {
        this.hostPath = value
    }

    /**
     * @param value Name of the volume. This name is referenced in the `sourceVolume`
     * parameter of container definition in the `mountPoints` section.
     */
    @JvmName("skdanmdgbneyyflx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block to configure a docker volume. Detailed below.
     */
    @JvmName("eccerhekiujyacjq")
    public suspend
    fun dockerVolumeConfiguration(`value`: TaskDefinitionVolumeDockerVolumeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerVolumeConfiguration = mapped
    }

    /**
     * @param argument Configuration block to configure a docker volume. Detailed below.
     */
    @JvmName("biyspfkknaexycrb")
    public suspend
    fun dockerVolumeConfiguration(argument: suspend TaskDefinitionVolumeDockerVolumeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = TaskDefinitionVolumeDockerVolumeConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dockerVolumeConfiguration = mapped
    }

    /**
     * @param value Configuration block for an EFS volume. Detailed below.
     */
    @JvmName("sxsqdspqivejbvso")
    public suspend
    fun efsVolumeConfiguration(`value`: TaskDefinitionVolumeEfsVolumeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.efsVolumeConfiguration = mapped
    }

    /**
     * @param argument Configuration block for an EFS volume. Detailed below.
     */
    @JvmName("abofyagfdofxduxl")
    public suspend
    fun efsVolumeConfiguration(argument: suspend TaskDefinitionVolumeEfsVolumeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = TaskDefinitionVolumeEfsVolumeConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.efsVolumeConfiguration = mapped
    }

    /**
     * @param value Configuration block for an FSX Windows File Server volume. Detailed below.
     */
    @JvmName("oncawcjeudxsfgew")
    public suspend
    fun fsxWindowsFileServerVolumeConfiguration(`value`: TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsxWindowsFileServerVolumeConfiguration = mapped
    }

    /**
     * @param argument Configuration block for an FSX Windows File Server volume. Detailed below.
     */
    @JvmName("wnwardwwxhxepfck")
    public suspend
    fun fsxWindowsFileServerVolumeConfiguration(argument: suspend TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fsxWindowsFileServerVolumeConfiguration = mapped
    }

    /**
     * @param value Path on the host container instance that is presented to the container. If not set, ECS will create a nonpersistent data volume that starts empty and is deleted after the task has finished.
     */
    @JvmName("ryvcjignofetqjrp")
    public suspend fun hostPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPath = mapped
    }

    /**
     * @param value Name of the volume. This name is referenced in the `sourceVolume`
     * parameter of container definition in the `mountPoints` section.
     */
    @JvmName("yfbfixlghdqhvlhk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): TaskDefinitionVolumeArgs = TaskDefinitionVolumeArgs(
        dockerVolumeConfiguration = dockerVolumeConfiguration,
        efsVolumeConfiguration = efsVolumeConfiguration,
        fsxWindowsFileServerVolumeConfiguration = fsxWindowsFileServerVolumeConfiguration,
        hostPath = hostPath,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
