@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeDockerVolumeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property autoprovision If this value is `true`, the Docker volume is created if it does not already exist. *Note*: This field is only used if the scope is `shared`.
 * @property driver Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement.
 * @property driverOpts Map of Docker driver specific options.
 * @property labels Map of custom metadata to add to your Docker volume.
 * @property scope Scope for the Docker volume, which determines its lifecycle, either `task` or `shared`.  Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
 */
public data class TaskDefinitionVolumeDockerVolumeConfigurationArgs(
    public val autoprovision: Output<Boolean>? = null,
    public val driver: Output<String>? = null,
    public val driverOpts: Output<Map<String, String>>? = null,
    public val labels: Output<Map<String, String>>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeDockerVolumeConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeDockerVolumeConfigurationArgs =
        com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeDockerVolumeConfigurationArgs.builder()
            .autoprovision(autoprovision?.applyValue({ args0 -> args0 }))
            .driver(driver?.applyValue({ args0 -> args0 }))
            .driverOpts(
                driverOpts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskDefinitionVolumeDockerVolumeConfigurationArgs].
 */
@PulumiTagMarker
public class TaskDefinitionVolumeDockerVolumeConfigurationArgsBuilder internal constructor() {
    private var autoprovision: Output<Boolean>? = null

    private var driver: Output<String>? = null

    private var driverOpts: Output<Map<String, String>>? = null

    private var labels: Output<Map<String, String>>? = null

    private var scope: Output<String>? = null

    /**
     * @param value If this value is `true`, the Docker volume is created if it does not already exist. *Note*: This field is only used if the scope is `shared`.
     */
    @JvmName("ttncmulkpyflmsyw")
    public suspend fun autoprovision(`value`: Output<Boolean>) {
        this.autoprovision = value
    }

    /**
     * @param value Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement.
     */
    @JvmName("aeugcivarqyywjvw")
    public suspend fun driver(`value`: Output<String>) {
        this.driver = value
    }

    /**
     * @param value Map of Docker driver specific options.
     */
    @JvmName("dfckevbwpfsutldq")
    public suspend fun driverOpts(`value`: Output<Map<String, String>>) {
        this.driverOpts = value
    }

    /**
     * @param value Map of custom metadata to add to your Docker volume.
     */
    @JvmName("tdcayrfpobmdgrcl")
    public suspend fun labels(`value`: Output<Map<String, String>>) {
        this.labels = value
    }

    /**
     * @param value Scope for the Docker volume, which determines its lifecycle, either `task` or `shared`.  Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
     */
    @JvmName("hbawudmammuyblpp")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value If this value is `true`, the Docker volume is created if it does not already exist. *Note*: This field is only used if the scope is `shared`.
     */
    @JvmName("xfcjpbhnbednhymt")
    public suspend fun autoprovision(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoprovision = mapped
    }

    /**
     * @param value Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement.
     */
    @JvmName("bbrkfongnhvdhdxu")
    public suspend fun driver(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driver = mapped
    }

    /**
     * @param value Map of Docker driver specific options.
     */
    @JvmName("cpbtjsdnbildyqce")
    public suspend fun driverOpts(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driverOpts = mapped
    }

    /**
     * @param values Map of Docker driver specific options.
     */
    @JvmName("enomyblvfxbhcsjl")
    public fun driverOpts(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.driverOpts = mapped
    }

    /**
     * @param value Map of custom metadata to add to your Docker volume.
     */
    @JvmName("preognqvawnmeotv")
    public suspend fun labels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values Map of custom metadata to add to your Docker volume.
     */
    @JvmName("xuahyvyksvllimwj")
    public fun labels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Scope for the Docker volume, which determines its lifecycle, either `task` or `shared`.  Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
     */
    @JvmName("wpiylfpxlkdxxpxd")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): TaskDefinitionVolumeDockerVolumeConfigurationArgs =
        TaskDefinitionVolumeDockerVolumeConfigurationArgs(
            autoprovision = autoprovision,
            driver = driver,
            driverOpts = driverOpts,
            labels = labels,
            scope = scope,
        )
}
