@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessPointId Access point ID to use. If an access point is specified, the root directory value will be relative to the directory set for the access point. If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
 * @property iam Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the EFSVolumeConfiguration. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
 */
public data class TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs(
    public val accessPointId: Output<String>? = null,
    public val iam: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs> {
    override fun toJava():
        com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs =
        com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs.builder()
            .accessPointId(accessPointId?.applyValue({ args0 -> args0 }))
            .iam(iam?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs].
 */
@PulumiTagMarker
public class TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgsBuilder internal
constructor() {
    private var accessPointId: Output<String>? = null

    private var iam: Output<String>? = null

    /**
     * @param value Access point ID to use. If an access point is specified, the root directory value will be relative to the directory set for the access point. If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
     */
    @JvmName("lddrbkbefqdtfiua")
    public suspend fun accessPointId(`value`: Output<String>) {
        this.accessPointId = value
    }

    /**
     * @param value Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the EFSVolumeConfiguration. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
     */
    @JvmName("grhobshbvevbngkj")
    public suspend fun iam(`value`: Output<String>) {
        this.iam = value
    }

    /**
     * @param value Access point ID to use. If an access point is specified, the root directory value will be relative to the directory set for the access point. If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
     */
    @JvmName("jyraxvkesubvxava")
    public suspend fun accessPointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPointId = mapped
    }

    /**
     * @param value Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the EFSVolumeConfiguration. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
     */
    @JvmName("csfrqekksayeuinm")
    public suspend fun iam(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iam = mapped
    }

    internal fun build(): TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs =
        TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs(
            accessPointId = accessPointId,
            iam = iam,
        )
}
