@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationConfig Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
 * @property fileSystemId The Amazon FSx for Windows File Server file system ID to use.
 * @property rootDirectory The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
 */
public data class TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs(
    public val authorizationConfig:
    Output<TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs>,
    public val fileSystemId: Output<String>,
    public val rootDirectory: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs =
        com.pulumi.aws.ecs.inputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs.builder()
            .authorizationConfig(
                authorizationConfig.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .fileSystemId(fileSystemId.applyValue({ args0 -> args0 }))
            .rootDirectory(rootDirectory.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs].
 */
@PulumiTagMarker
public class TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgsBuilder internal
constructor() {
    private var authorizationConfig:
        Output<TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs>? =
        null

    private var fileSystemId: Output<String>? = null

    private var rootDirectory: Output<String>? = null

    /**
     * @param value Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
     */
    @JvmName("pigwkercbxawygak")
    public suspend
    fun authorizationConfig(`value`: Output<TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs>) {
        this.authorizationConfig = value
    }

    /**
     * @param value The Amazon FSx for Windows File Server file system ID to use.
     */
    @JvmName("gxpeqnniheifkpni")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
     */
    @JvmName("vpsaejqcaafompkh")
    public suspend fun rootDirectory(`value`: Output<String>) {
        this.rootDirectory = value
    }

    /**
     * @param value Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
     */
    @JvmName("snekqrmiqvinxbwc")
    public suspend
    fun authorizationConfig(`value`: TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationConfig = mapped
    }

    /**
     * @param argument Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
     */
    @JvmName("pctlufrmurcxrnbl")
    public suspend
    fun authorizationConfig(argument: suspend TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.authorizationConfig = mapped
    }

    /**
     * @param value The Amazon FSx for Windows File Server file system ID to use.
     */
    @JvmName("hvulvnjjsbrodxxt")
    public suspend fun fileSystemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
     */
    @JvmName("nqtfwiupfjrhriji")
    public suspend fun rootDirectory(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rootDirectory = mapped
    }

    internal fun build(): TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs =
        TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs(
            authorizationConfig = authorizationConfig ?: throw PulumiNullFieldException("authorizationConfig"),
            fileSystemId = fileSystemId ?: throw PulumiNullFieldException("fileSystemId"),
            rootDirectory = rootDirectory ?: throw PulumiNullFieldException("rootDirectory"),
        )
}
