@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskSetLoadBalancerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerName The name of the container to associate with the load balancer (as it appears in a container definition).
 * @property containerPort The port on the container to associate with the load balancer. Defaults to `0` if not specified.
 * > **Note:** Specifying multiple `load_balancer` configurations is still not supported by AWS for ECS task set.
 * @property loadBalancerName The name of the ELB (Classic) to associate with the service.
 * @property targetGroupArn The ARN of the Load Balancer target group to associate with the service.
 */
public data class TaskSetLoadBalancerArgs(
    public val containerName: Output<String>,
    public val containerPort: Output<Int>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val targetGroupArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskSetLoadBalancerArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskSetLoadBalancerArgs =
        com.pulumi.aws.ecs.inputs.TaskSetLoadBalancerArgs.builder()
            .containerName(containerName.applyValue({ args0 -> args0 }))
            .containerPort(containerPort?.applyValue({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .targetGroupArn(targetGroupArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskSetLoadBalancerArgs].
 */
@PulumiTagMarker
public class TaskSetLoadBalancerArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var containerPort: Output<Int>? = null

    private var loadBalancerName: Output<String>? = null

    private var targetGroupArn: Output<String>? = null

    /**
     * @param value The name of the container to associate with the load balancer (as it appears in a container definition).
     */
    @JvmName("ilmdbpltxfhgrtxo")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value The port on the container to associate with the load balancer. Defaults to `0` if not specified.
     * > **Note:** Specifying multiple `load_balancer` configurations is still not supported by AWS for ECS task set.
     */
    @JvmName("jwpwwagakoqrhvdp")
    public suspend fun containerPort(`value`: Output<Int>) {
        this.containerPort = value
    }

    /**
     * @param value The name of the ELB (Classic) to associate with the service.
     */
    @JvmName("fasnfxbtriduoest")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value The ARN of the Load Balancer target group to associate with the service.
     */
    @JvmName("etadsbnkqogfuslk")
    public suspend fun targetGroupArn(`value`: Output<String>) {
        this.targetGroupArn = value
    }

    /**
     * @param value The name of the container to associate with the load balancer (as it appears in a container definition).
     */
    @JvmName("ovycexyknwekhxrt")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value The port on the container to associate with the load balancer. Defaults to `0` if not specified.
     * > **Note:** Specifying multiple `load_balancer` configurations is still not supported by AWS for ECS task set.
     */
    @JvmName("bfoaqkjdxasowxeo")
    public suspend fun containerPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerPort = mapped
    }

    /**
     * @param value The name of the ELB (Classic) to associate with the service.
     */
    @JvmName("njtamsryubrosqfi")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The ARN of the Load Balancer target group to associate with the service.
     */
    @JvmName("qoppirnnibefnrhm")
    public suspend fun targetGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupArn = mapped
    }

    internal fun build(): TaskSetLoadBalancerArgs = TaskSetLoadBalancerArgs(
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        containerPort = containerPort,
        loadBalancerName = loadBalancerName,
        targetGroupArn = targetGroupArn,
    )
}
