@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.inputs

import com.pulumi.aws.ecs.inputs.TaskSetScaleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property unit The unit of measure for the scale value. Default: `PERCENT`.
 * @property value The value, specified as a percent total of a service's `desiredCount`, to scale the task set. Defaults to `0` if not specified. Accepted values are numbers between 0.0 and 100.0.
 */
public data class TaskSetScaleArgs(
    public val unit: Output<String>? = null,
    public val `value`: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecs.inputs.TaskSetScaleArgs> {
    override fun toJava(): com.pulumi.aws.ecs.inputs.TaskSetScaleArgs =
        com.pulumi.aws.ecs.inputs.TaskSetScaleArgs.builder()
            .unit(unit?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskSetScaleArgs].
 */
@PulumiTagMarker
public class TaskSetScaleArgsBuilder internal constructor() {
    private var unit: Output<String>? = null

    private var `value`: Output<Double>? = null

    /**
     * @param value The unit of measure for the scale value. Default: `PERCENT`.
     */
    @JvmName("fqrnxjrcokhmqxyj")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value The value, specified as a percent total of a service's `desiredCount`, to scale the task set. Defaults to `0` if not specified. Accepted values are numbers between 0.0 and 100.0.
     */
    @JvmName("wuyabyitnhynlewd")
    public suspend fun `value`(`value`: Output<Double>) {
        this.`value` = value
    }

    /**
     * @param value The unit of measure for the scale value. Default: `PERCENT`.
     */
    @JvmName("sknylsuwmjuxqrld")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    /**
     * @param value The value, specified as a percent total of a service's `desiredCount`, to scale the task set. Defaults to `0` if not specified. Accepted values are numbers between 0.0 and 100.0.
     */
    @JvmName("dxpybwhljacymgtv")
    public suspend fun `value`(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TaskSetScaleArgs = TaskSetScaleArgs(
        unit = unit,
        `value` = `value`,
    )
}
