@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoScalingGroupArn ARN of the associated auto scaling group.
 * @property managedScaling Configuration block defining the parameters of the auto scaling. Detailed below.
 * @property managedTerminationProtection Enables or disables container-aware termination of instances in the auto scaling group when scale-in happens. Valid values are `ENABLED` and `DISABLED`.
 */
public data class CapacityProviderAutoScalingGroupProvider(
    public val autoScalingGroupArn: String,
    public val managedScaling: CapacityProviderAutoScalingGroupProviderManagedScaling? = null,
    public val managedTerminationProtection: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.CapacityProviderAutoScalingGroupProvider):
            CapacityProviderAutoScalingGroupProvider = CapacityProviderAutoScalingGroupProvider(
            autoScalingGroupArn = javaType.autoScalingGroupArn(),
            managedScaling = javaType.managedScaling().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.CapacityProviderAutoScalingGroupProviderManagedScaling.Companion.toKotlin(args0)
                })
            }).orElse(null),
            managedTerminationProtection = javaType.managedTerminationProtection().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
