@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudWatchEncryptionEnabled Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
 * @property cloudWatchLogGroupName The name of the CloudWatch log group to send logs to.
 * @property s3BucketEncryptionEnabled Whether or not to enable encryption on the logs sent to S3. If not specified, encryption will be disabled.
 * @property s3BucketName The name of the S3 bucket to send logs to.
 * @property s3KeyPrefix An optional folder in the S3 bucket to place logs in.
 */
public data class ClusterConfigurationExecuteCommandConfigurationLogConfiguration(
    public val cloudWatchEncryptionEnabled: Boolean? = null,
    public val cloudWatchLogGroupName: String? = null,
    public val s3BucketEncryptionEnabled: Boolean? = null,
    public val s3BucketName: String? = null,
    public val s3KeyPrefix: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ClusterConfigurationExecuteCommandConfigurationLogConfiguration):
            ClusterConfigurationExecuteCommandConfigurationLogConfiguration =
            ClusterConfigurationExecuteCommandConfigurationLogConfiguration(
                cloudWatchEncryptionEnabled = javaType.cloudWatchEncryptionEnabled().map({ args0 ->
                    args0
                }).orElse(null),
                cloudWatchLogGroupName = javaType.cloudWatchLogGroupName().map({ args0 -> args0 }).orElse(null),
                s3BucketEncryptionEnabled = javaType.s3BucketEncryptionEnabled().map({ args0 ->
                    args0
                }).orElse(null),
                s3BucketName = javaType.s3BucketName().map({ args0 -> args0 }).orElse(null),
                s3KeyPrefix = javaType.s3KeyPrefix().map({ args0 -> args0 }).orElse(null),
            )
    }
}
