@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerOverrides One or more container overrides that are sent to a task. See below.
 * @property cpu The CPU override for the task.
 * @property executionRoleArn Amazon Resource Name (ARN) of the task execution role override for the task.
 * @property inferenceAcceleratorOverrides Elastic Inference accelerator override for the task. See below.
 * @property memory The memory override for the task.
 * @property taskRoleArn Amazon Resource Name (ARN) of the role that containers in this task can assume.
 */
public data class GetTaskExecutionOverrides(
    public val containerOverrides: List<GetTaskExecutionOverridesContainerOverride>? = null,
    public val cpu: String? = null,
    public val executionRoleArn: String? = null,
    public val inferenceAcceleratorOverrides:
    List<GetTaskExecutionOverridesInferenceAcceleratorOverride>? = null,
    public val memory: String? = null,
    public val taskRoleArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.GetTaskExecutionOverrides):
            GetTaskExecutionOverrides = GetTaskExecutionOverrides(
            containerOverrides = javaType.containerOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionOverridesContainerOverride.Companion.toKotlin(args0)
                })
            }),
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            executionRoleArn = javaType.executionRoleArn().map({ args0 -> args0 }).orElse(null),
            inferenceAcceleratorOverrides = javaType.inferenceAcceleratorOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.GetTaskExecutionOverridesInferenceAcceleratorOverride.Companion.toKotlin(args0)
                })
            }),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
            taskRoleArn = javaType.taskRoleArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
