@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property base Number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
 * @property capacityProvider Short name of the capacity provider.
 * @property weight Relative percentage of the total number of launched tasks that should use the specified capacity provider.
 */
public data class ServiceCapacityProviderStrategy(
    public val base: Int? = null,
    public val capacityProvider: String,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceCapacityProviderStrategy):
            ServiceCapacityProviderStrategy = ServiceCapacityProviderStrategy(
            base = javaType.base().map({ args0 -> args0 }).orElse(null),
            capacityProvider = javaType.capacityProvider(),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
