@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enabled Specifies whether to use Service Connect with this service.
 * @property logConfiguration The log configuration for the container. See below.
 * @property namespace The namespace name or ARN of the `aws.servicediscovery.HttpNamespace` for use with Service Connect.
 * @property services The list of Service Connect service objects. See below.
 */
public data class ServiceServiceConnectConfiguration(
    public val enabled: Boolean,
    public val logConfiguration: ServiceServiceConnectConfigurationLogConfiguration? = null,
    public val namespace: String? = null,
    public val services: List<ServiceServiceConnectConfigurationService>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceServiceConnectConfiguration):
            ServiceServiceConnectConfiguration = ServiceServiceConnectConfiguration(
            enabled = javaType.enabled(),
            logConfiguration = javaType.logConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.ServiceServiceConnectConfigurationLogConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            services = javaType.services().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.ServiceServiceConnectConfigurationService.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
