@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property logDriver The log driver to use for the container.
 * @property options The configuration options to send to the log driver.
 * @property secretOptions The secrets to pass to the log configuration. See below.
 */
public data class ServiceServiceConnectConfigurationLogConfiguration(
    public val logDriver: String,
    public val options: Map<String, String>? = null,
    public val secretOptions: List<ServiceServiceConnectConfigurationLogConfigurationSecretOption>? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceServiceConnectConfigurationLogConfiguration):
            ServiceServiceConnectConfigurationLogConfiguration =
            ServiceServiceConnectConfigurationLogConfiguration(
                logDriver = javaType.logDriver(),
                options = javaType.options().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                secretOptions = javaType.secretOptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ecs.kotlin.outputs.ServiceServiceConnectConfigurationLogConfigurationSecretOption.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
