@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the secret.
 * @property valueFrom The secret to expose to the container. The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
 */
public data class ServiceServiceConnectConfigurationLogConfigurationSecretOption(
    public val name: String,
    public val valueFrom: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.ServiceServiceConnectConfigurationLogConfigurationSecretOption):
            ServiceServiceConnectConfigurationLogConfigurationSecretOption =
            ServiceServiceConnectConfigurationLogConfigurationSecretOption(
                name = javaType.name(),
                valueFrom = javaType.valueFrom(),
            )
    }
}
