@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deviceName Elastic Inference accelerator device name. The deviceName must also be referenced in a container definition as a ResourceRequirement.
 * @property deviceType Elastic Inference accelerator type to use.
 */
public data class TaskDefinitionInferenceAccelerator(
    public val deviceName: String,
    public val deviceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskDefinitionInferenceAccelerator):
            TaskDefinitionInferenceAccelerator = TaskDefinitionInferenceAccelerator(
            deviceName = javaType.deviceName(),
            deviceType = javaType.deviceType(),
        )
    }
}
