@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property expression Cluster Query Language expression to apply to the constraint. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
 * @property type Type of constraint. Use `memberOf` to restrict selection to a group of valid candidates. Note that `distinctInstance` is not supported in task definitions.
 */
public data class TaskDefinitionPlacementConstraint(
    public val expression: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskDefinitionPlacementConstraint):
            TaskDefinitionPlacementConstraint = TaskDefinitionPlacementConstraint(
            expression = javaType.expression().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
