@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property containerName Name of the container that will serve as the App Mesh proxy.
 * @property properties Set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified a key-value mapping.
 * @property type Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
 */
public data class TaskDefinitionProxyConfiguration(
    public val containerName: String,
    public val properties: Map<String, String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskDefinitionProxyConfiguration):
            TaskDefinitionProxyConfiguration = TaskDefinitionProxyConfiguration(
            containerName = javaType.containerName(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
