@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpuArchitecture Must be set to either `X86_64` or `ARM64`; see [cpu architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform)
 * @property operatingSystemFamily If the `requires_compatibilities` is `FARGATE` this field is required; must be set to a valid option from the [operating system family in the runtime platform](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform) setting
 */
public data class TaskDefinitionRuntimePlatform(
    public val cpuArchitecture: String? = null,
    public val operatingSystemFamily: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskDefinitionRuntimePlatform):
            TaskDefinitionRuntimePlatform = TaskDefinitionRuntimePlatform(
            cpuArchitecture = javaType.cpuArchitecture().map({ args0 -> args0 }).orElse(null),
            operatingSystemFamily = javaType.operatingSystemFamily().map({ args0 -> args0 }).orElse(null),
        )
    }
}
