@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dockerVolumeConfiguration Configuration block to configure a docker volume. Detailed below.
 * @property efsVolumeConfiguration Configuration block for an EFS volume. Detailed below.
 * @property fsxWindowsFileServerVolumeConfiguration Configuration block for an FSX Windows File Server volume. Detailed below.
 * @property hostPath Path on the host container instance that is presented to the container. If not set, ECS will create a nonpersistent data volume that starts empty and is deleted after the task has finished.
 * @property name Name of the volume. This name is referenced in the `sourceVolume`
 * parameter of container definition in the `mountPoints` section.
 */
public data class TaskDefinitionVolume(
    public val dockerVolumeConfiguration: TaskDefinitionVolumeDockerVolumeConfiguration? = null,
    public val efsVolumeConfiguration: TaskDefinitionVolumeEfsVolumeConfiguration? = null,
    public val fsxWindowsFileServerVolumeConfiguration:
    TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration? = null,
    public val hostPath: String? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskDefinitionVolume):
            TaskDefinitionVolume = TaskDefinitionVolume(
            dockerVolumeConfiguration = javaType.dockerVolumeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionVolumeDockerVolumeConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            efsVolumeConfiguration = javaType.efsVolumeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionVolumeEfsVolumeConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fsxWindowsFileServerVolumeConfiguration = javaType.fsxWindowsFileServerVolumeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostPath = javaType.hostPath().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
