@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorizationConfig Configuration block for authorization for the Amazon EFS file system. Detailed below.
 * @property fileSystemId ID of the EFS File System.
 * @property rootDirectory Directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume will be used. Specifying / will have the same effect as omitting this parameter. This argument is ignored when using `authorization_config`.
 * @property transitEncryption Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
 * @property transitEncryptionPort Port to use for transit encryption. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses.
 */
public data class TaskDefinitionVolumeEfsVolumeConfiguration(
    public val authorizationConfig: TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig? =
        null,
    public val fileSystemId: String,
    public val rootDirectory: String? = null,
    public val transitEncryption: String? = null,
    public val transitEncryptionPort: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskDefinitionVolumeEfsVolumeConfiguration):
            TaskDefinitionVolumeEfsVolumeConfiguration = TaskDefinitionVolumeEfsVolumeConfiguration(
            authorizationConfig = javaType.authorizationConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ecs.kotlin.outputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fileSystemId = javaType.fileSystemId(),
            rootDirectory = javaType.rootDirectory().map({ args0 -> args0 }).orElse(null),
            transitEncryption = javaType.transitEncryption().map({ args0 -> args0 }).orElse(null),
            transitEncryptionPort = javaType.transitEncryptionPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
