@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessPointId Access point ID to use. If an access point is specified, the root directory value will be relative to the directory set for the access point. If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
 * @property iam Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the EFSVolumeConfiguration. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
 */
public data class TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig(
    public val accessPointId: String? = null,
    public val iam: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig):
            TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig =
            TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig(
                accessPointId = javaType.accessPointId().map({ args0 -> args0 }).orElse(null),
                iam = javaType.iam().map({ args0 -> args0 }).orElse(null),
            )
    }
}
