@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property containerName The name of the container to associate with the load balancer (as it appears in a container definition).
 * @property containerPort The port on the container to associate with the load balancer. Defaults to `0` if not specified.
 * > **Note:** Specifying multiple `load_balancer` configurations is still not supported by AWS for ECS task set.
 * @property loadBalancerName The name of the ELB (Classic) to associate with the service.
 * @property targetGroupArn The ARN of the Load Balancer target group to associate with the service.
 */
public data class TaskSetLoadBalancer(
    public val containerName: String,
    public val containerPort: Int? = null,
    public val loadBalancerName: String? = null,
    public val targetGroupArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskSetLoadBalancer):
            TaskSetLoadBalancer = TaskSetLoadBalancer(
            containerName = javaType.containerName(),
            containerPort = javaType.containerPort().map({ args0 -> args0 }).orElse(null),
            loadBalancerName = javaType.loadBalancerName().map({ args0 -> args0 }).orElse(null),
            targetGroupArn = javaType.targetGroupArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
