@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property assignPublicIp Whether to assign a public IP address to the ENI (`FARGATE` launch type only). Valid values are `true` or `false`. Default `false`.
 * For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html).
 * @property securityGroups The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. Maximum of 5.
 * @property subnets The subnets associated with the task or service. Maximum of 16.
 */
public data class TaskSetNetworkConfiguration(
    public val assignPublicIp: Boolean? = null,
    public val securityGroups: List<String>? = null,
    public val subnets: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskSetNetworkConfiguration):
            TaskSetNetworkConfiguration = TaskSetNetworkConfiguration(
            assignPublicIp = javaType.assignPublicIp().map({ args0 -> args0 }).orElse(null),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            subnets = javaType.subnets().map({ args0 -> args0 }),
        )
    }
}
