@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property unit The unit of measure for the scale value. Default: `PERCENT`.
 * @property value The value, specified as a percent total of a service's `desiredCount`, to scale the task set. Defaults to `0` if not specified. Accepted values are numbers between 0.0 and 100.0.
 */
public data class TaskSetScale(
    public val unit: String? = null,
    public val `value`: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskSetScale): TaskSetScale =
            TaskSetScale(
                unit = javaType.unit().map({ args0 -> args0 }).orElse(null),
                `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            )
    }
}
