@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property containerName The container name value, already specified in the task definition, to be used for your service discovery service.
 * @property containerPort The port value, already specified in the task definition, to be used for your service discovery service.
 * @property port The port value used if your Service Discovery service specified an SRV record.
 * @property registryArn The ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`aws.servicediscovery.Service` resource). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html).
 */
public data class TaskSetServiceRegistries(
    public val containerName: String? = null,
    public val containerPort: Int? = null,
    public val port: Int? = null,
    public val registryArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskSetServiceRegistries):
            TaskSetServiceRegistries = TaskSetServiceRegistries(
            containerName = javaType.containerName().map({ args0 -> args0 }).orElse(null),
            containerPort = javaType.containerPort().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            registryArn = javaType.registryArn(),
        )
    }
}
