@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.kotlin.outputs.AccessPointPosixUser
import com.pulumi.aws.efs.kotlin.outputs.AccessPointRootDirectory
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.efs.kotlin.outputs.AccessPointPosixUser.Companion.toKotlin as accessPointPosixUserToKotlin
import com.pulumi.aws.efs.kotlin.outputs.AccessPointRootDirectory.Companion.toKotlin as accessPointRootDirectoryToKotlin

/**
 * Builder for [AccessPoint].
 */
@PulumiTagMarker
public class AccessPointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessPointArgs = AccessPointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessPointArgsBuilder.() -> Unit) {
        val builder = AccessPointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccessPoint {
        val builtJavaResource = com.pulumi.aws.efs.AccessPoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessPoint(builtJavaResource)
    }
}

/**
 * Provides an Elastic File System (EFS) access point.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.AccessPoint;
 * import com.pulumi.aws.efs.AccessPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AccessPoint("test", AccessPointArgs.builder()
 *             .fileSystemId(aws_efs_file_system.foo().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the EFS access points using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:efs/accessPoint:AccessPoint test fsap-52a643fb
 * ```
 *
 */
public class AccessPoint internal constructor(
    override val javaResource: com.pulumi.aws.efs.AccessPoint,
) : KotlinCustomResource(javaResource, AccessPointMapper) {
    /**
     * ARN of the access point.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN of the file system.
     */
    public val fileSystemArn: Output<String>
        get() = javaResource.fileSystemArn().applyValue({ args0 -> args0 })

    /**
     * ID of the file system for which the access point is intended.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Operating system user and group applied to all file system requests made using the access point. Detailed below.
     */
    public val posixUser: Output<AccessPointPosixUser>?
        get() = javaResource.posixUser().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    accessPointPosixUserToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Directory on the Amazon EFS file system that the access point provides access to. Detailed below.
     */
    public val rootDirectory: Output<AccessPointRootDirectory>
        get() = javaResource.rootDirectory().applyValue({ args0 ->
            args0.let({ args0 ->
                accessPointRootDirectoryToKotlin(args0)
            })
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AccessPointMapper : ResourceMapper<AccessPoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.efs.AccessPoint::class == javaResource::class

    override fun map(javaResource: Resource): AccessPoint = AccessPoint(
        javaResource as
            com.pulumi.aws.efs.AccessPoint,
    )
}

/**
 * @see [AccessPoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessPoint].
 */
public suspend fun accessPoint(name: String, block: suspend AccessPointResourceBuilder.() -> Unit):
    AccessPoint {
    val builder = AccessPointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessPoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessPoint(name: String): AccessPoint {
    val builder = AccessPointResourceBuilder()
    builder.name(name)
    return builder.build()
}
