@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.AccessPointArgs.builder
import com.pulumi.aws.efs.kotlin.inputs.AccessPointPosixUserArgs
import com.pulumi.aws.efs.kotlin.inputs.AccessPointPosixUserArgsBuilder
import com.pulumi.aws.efs.kotlin.inputs.AccessPointRootDirectoryArgs
import com.pulumi.aws.efs.kotlin.inputs.AccessPointRootDirectoryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic File System (EFS) access point.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.AccessPoint;
 * import com.pulumi.aws.efs.AccessPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AccessPoint("test", AccessPointArgs.builder()
 *             .fileSystemId(aws_efs_file_system.foo().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the EFS access points using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:efs/accessPoint:AccessPoint test fsap-52a643fb
 * ```
 * @property fileSystemId ID of the file system for which the access point is intended.
 * @property posixUser Operating system user and group applied to all file system requests made using the access point. Detailed below.
 * @property rootDirectory Directory on the Amazon EFS file system that the access point provides access to. Detailed below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class AccessPointArgs(
    public val fileSystemId: Output<String>? = null,
    public val posixUser: Output<AccessPointPosixUserArgs>? = null,
    public val rootDirectory: Output<AccessPointRootDirectoryArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.AccessPointArgs> {
    override fun toJava(): com.pulumi.aws.efs.AccessPointArgs =
        com.pulumi.aws.efs.AccessPointArgs.builder()
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .posixUser(posixUser?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rootDirectory(rootDirectory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccessPointArgs].
 */
@PulumiTagMarker
public class AccessPointArgsBuilder internal constructor() {
    private var fileSystemId: Output<String>? = null

    private var posixUser: Output<AccessPointPosixUserArgs>? = null

    private var rootDirectory: Output<AccessPointRootDirectoryArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ID of the file system for which the access point is intended.
     */
    @JvmName("dkohldtjbyagekmg")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value Operating system user and group applied to all file system requests made using the access point. Detailed below.
     */
    @JvmName("covkgdotqklvgtsx")
    public suspend fun posixUser(`value`: Output<AccessPointPosixUserArgs>) {
        this.posixUser = value
    }

    /**
     * @param value Directory on the Amazon EFS file system that the access point provides access to. Detailed below.
     */
    @JvmName("yjlllybhabuffrcf")
    public suspend fun rootDirectory(`value`: Output<AccessPointRootDirectoryArgs>) {
        this.rootDirectory = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("scsrvisspueohwoc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID of the file system for which the access point is intended.
     */
    @JvmName("anxuwtnylkljgdva")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value Operating system user and group applied to all file system requests made using the access point. Detailed below.
     */
    @JvmName("ajofcfnlqghpiylc")
    public suspend fun posixUser(`value`: AccessPointPosixUserArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.posixUser = mapped
    }

    /**
     * @param argument Operating system user and group applied to all file system requests made using the access point. Detailed below.
     */
    @JvmName("sktvyqngctueurhu")
    public suspend fun posixUser(argument: suspend AccessPointPosixUserArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPointPosixUserArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.posixUser = mapped
    }

    /**
     * @param value Directory on the Amazon EFS file system that the access point provides access to. Detailed below.
     */
    @JvmName("dalvjvaoucevscbd")
    public suspend fun rootDirectory(`value`: AccessPointRootDirectoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootDirectory = mapped
    }

    /**
     * @param argument Directory on the Amazon EFS file system that the access point provides access to. Detailed below.
     */
    @JvmName("gonvfnfwklxkockk")
    public suspend
    fun rootDirectory(argument: suspend AccessPointRootDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPointRootDirectoryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rootDirectory = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("loesncqmfwmhthpx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("ulfmcihtbvyhnvaq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccessPointArgs = AccessPointArgs(
        fileSystemId = fileSystemId,
        posixUser = posixUser,
        rootDirectory = rootDirectory,
        tags = tags,
    )
}
