@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.BackupPolicyArgs.builder
import com.pulumi.aws.efs.kotlin.inputs.BackupPolicyBackupPolicyArgs
import com.pulumi.aws.efs.kotlin.inputs.BackupPolicyBackupPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an Elastic File System (EFS) Backup Policy resource.
 * Backup policies turn automatic backups on or off for an existing file system.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.BackupPolicy;
 * import com.pulumi.aws.efs.BackupPolicyArgs;
 * import com.pulumi.aws.efs.inputs.BackupPolicyBackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fs = new FileSystem("fs");
 *         var policy = new BackupPolicy("policy", BackupPolicyArgs.builder()
 *             .fileSystemId(fs.id())
 *             .backupPolicy(BackupPolicyBackupPolicyArgs.builder()
 *                 .status("ENABLED")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the EFS backup policies using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:efs/backupPolicy:BackupPolicy example fs-6fa144c6
 * ```
 * @property backupPolicy A backup_policy object (documented below).
 * @property fileSystemId The ID of the EFS file system.
 */
public data class BackupPolicyArgs(
    public val backupPolicy: Output<BackupPolicyBackupPolicyArgs>? = null,
    public val fileSystemId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.BackupPolicyArgs> {
    override fun toJava(): com.pulumi.aws.efs.BackupPolicyArgs =
        com.pulumi.aws.efs.BackupPolicyArgs.builder()
            .backupPolicy(backupPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupPolicyArgs].
 */
@PulumiTagMarker
public class BackupPolicyArgsBuilder internal constructor() {
    private var backupPolicy: Output<BackupPolicyBackupPolicyArgs>? = null

    private var fileSystemId: Output<String>? = null

    /**
     * @param value A backup_policy object (documented below).
     */
    @JvmName("jppypqwrkptbanqi")
    public suspend fun backupPolicy(`value`: Output<BackupPolicyBackupPolicyArgs>) {
        this.backupPolicy = value
    }

    /**
     * @param value The ID of the EFS file system.
     */
    @JvmName("mfrnsfykbypxaqgh")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value A backup_policy object (documented below).
     */
    @JvmName("emybtyrlkoyrfyss")
    public suspend fun backupPolicy(`value`: BackupPolicyBackupPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPolicy = mapped
    }

    /**
     * @param argument A backup_policy object (documented below).
     */
    @JvmName("jdcuhcrankdxaosm")
    public suspend
    fun backupPolicy(argument: suspend BackupPolicyBackupPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = BackupPolicyBackupPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupPolicy = mapped
    }

    /**
     * @param value The ID of the EFS file system.
     */
    @JvmName("vuyxxgyjplbeuhol")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    internal fun build(): BackupPolicyArgs = BackupPolicyArgs(
        backupPolicy = backupPolicy,
        fileSystemId = fileSystemId,
    )
}
