@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.EfsFunctions.getAccessPointPlain
import com.pulumi.aws.efs.EfsFunctions.getAccessPointsPlain
import com.pulumi.aws.efs.EfsFunctions.getFileSystemPlain
import com.pulumi.aws.efs.EfsFunctions.getMountTargetPlain
import com.pulumi.aws.efs.kotlin.inputs.GetAccessPointPlainArgs
import com.pulumi.aws.efs.kotlin.inputs.GetAccessPointPlainArgsBuilder
import com.pulumi.aws.efs.kotlin.inputs.GetAccessPointsPlainArgs
import com.pulumi.aws.efs.kotlin.inputs.GetAccessPointsPlainArgsBuilder
import com.pulumi.aws.efs.kotlin.inputs.GetFileSystemPlainArgs
import com.pulumi.aws.efs.kotlin.inputs.GetFileSystemPlainArgsBuilder
import com.pulumi.aws.efs.kotlin.inputs.GetMountTargetPlainArgs
import com.pulumi.aws.efs.kotlin.inputs.GetMountTargetPlainArgsBuilder
import com.pulumi.aws.efs.kotlin.outputs.GetAccessPointResult
import com.pulumi.aws.efs.kotlin.outputs.GetAccessPointsResult
import com.pulumi.aws.efs.kotlin.outputs.GetFileSystemResult
import com.pulumi.aws.efs.kotlin.outputs.GetMountTargetResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.efs.kotlin.outputs.GetAccessPointResult.Companion.toKotlin as getAccessPointResultToKotlin
import com.pulumi.aws.efs.kotlin.outputs.GetAccessPointsResult.Companion.toKotlin as getAccessPointsResultToKotlin
import com.pulumi.aws.efs.kotlin.outputs.GetFileSystemResult.Companion.toKotlin as getFileSystemResultToKotlin
import com.pulumi.aws.efs.kotlin.outputs.GetMountTargetResult.Companion.toKotlin as getMountTargetResultToKotlin

public object EfsFunctions {
    /**
     * Provides information about an Elastic File System (EFS) Access Point.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.efs.EfsFunctions;
     * import com.pulumi.aws.efs.inputs.GetAccessPointArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = EfsFunctions.getAccessPoint(GetAccessPointArgs.builder()
     *             .accessPointId("fsap-12345678")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAccessPoint.
     * @return A collection of values returned by getAccessPoint.
     */
    public suspend fun getAccessPoint(argument: GetAccessPointPlainArgs): GetAccessPointResult =
        getAccessPointResultToKotlin(getAccessPointPlain(argument.toJava()).await())

    /**
     * @see [getAccessPoint].
     * @param accessPointId ID that identifies the file system.
     * @param tags Key-value mapping of resource tags.
     * @return A collection of values returned by getAccessPoint.
     */
    public suspend fun getAccessPoint(accessPointId: String, tags: Map<String, String>? = null):
        GetAccessPointResult {
        val argument = GetAccessPointPlainArgs(
            accessPointId = accessPointId,
            tags = tags,
        )
        return getAccessPointResultToKotlin(getAccessPointPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessPoint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;efs&#46;kotlin&#46;inputs&#46;GetAccessPointPlainArgs].
     * @return A collection of values returned by getAccessPoint.
     */
    public suspend fun getAccessPoint(argument: suspend GetAccessPointPlainArgsBuilder.() -> Unit):
        GetAccessPointResult {
        val builder = GetAccessPointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessPointResultToKotlin(getAccessPointPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about multiple Elastic File System (EFS) Access Points.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.efs.EfsFunctions;
     * import com.pulumi.aws.efs.inputs.GetAccessPointsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = EfsFunctions.getAccessPoints(GetAccessPointsArgs.builder()
     *             .fileSystemId("fs-12345678")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAccessPoints.
     * @return A collection of values returned by getAccessPoints.
     */
    public suspend fun getAccessPoints(argument: GetAccessPointsPlainArgs): GetAccessPointsResult =
        getAccessPointsResultToKotlin(getAccessPointsPlain(argument.toJava()).await())

    /**
     * @see [getAccessPoints].
     * @param fileSystemId EFS File System identifier.
     * @return A collection of values returned by getAccessPoints.
     */
    public suspend fun getAccessPoints(fileSystemId: String): GetAccessPointsResult {
        val argument = GetAccessPointsPlainArgs(
            fileSystemId = fileSystemId,
        )
        return getAccessPointsResultToKotlin(getAccessPointsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessPoints].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;efs&#46;kotlin&#46;inputs&#46;GetAccessPointsPlainArgs].
     * @return A collection of values returned by getAccessPoints.
     */
    public suspend fun getAccessPoints(argument: suspend GetAccessPointsPlainArgsBuilder.() -> Unit):
        GetAccessPointsResult {
        val builder = GetAccessPointsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessPointsResultToKotlin(getAccessPointsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about an Elastic File System (EFS) File System.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.efs.EfsFunctions;
     * import com.pulumi.aws.efs.inputs.GetFileSystemArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var fileSystemId = config.get("fileSystemId").orElse("");
     *         final var byId = EfsFunctions.getFileSystem(GetFileSystemArgs.builder()
     *             .fileSystemId(fileSystemId)
     *             .build());
     *         final var byTag = EfsFunctions.getFileSystem(GetFileSystemArgs.builder()
     *             .tags(Map.of("Environment", "dev"))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getFileSystem.
     * @return A collection of values returned by getFileSystem.
     */
    public suspend fun getFileSystem(argument: GetFileSystemPlainArgs): GetFileSystemResult =
        getFileSystemResultToKotlin(getFileSystemPlain(argument.toJava()).await())

    /**
     * @see [getFileSystem].
     * @param creationToken Restricts the list to the file system with this creation token.
     * @param fileSystemId ID that identifies the file system (e.g., fs-ccfc0d65).
     * @param tags Restricts the list to the file system with these tags.
     * @return A collection of values returned by getFileSystem.
     */
    public suspend fun getFileSystem(
        creationToken: String? = null,
        fileSystemId: String? = null,
        tags: Map<String, String>? = null,
    ): GetFileSystemResult {
        val argument = GetFileSystemPlainArgs(
            creationToken = creationToken,
            fileSystemId = fileSystemId,
            tags = tags,
        )
        return getFileSystemResultToKotlin(getFileSystemPlain(argument.toJava()).await())
    }

    /**
     * @see [getFileSystem].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;efs&#46;kotlin&#46;inputs&#46;GetFileSystemPlainArgs].
     * @return A collection of values returned by getFileSystem.
     */
    public suspend fun getFileSystem(argument: suspend GetFileSystemPlainArgsBuilder.() -> Unit):
        GetFileSystemResult {
        val builder = GetFileSystemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFileSystemResultToKotlin(getFileSystemPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about an Elastic File System Mount Target (EFS).
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.efs.EfsFunctions;
     * import com.pulumi.aws.efs.inputs.GetMountTargetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var mountTargetId = config.get("mountTargetId").orElse("");
     *         final var byId = EfsFunctions.getMountTarget(GetMountTargetArgs.builder()
     *             .mountTargetId(mountTargetId)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getMountTarget.
     * @return A collection of values returned by getMountTarget.
     */
    public suspend fun getMountTarget(argument: GetMountTargetPlainArgs): GetMountTargetResult =
        getMountTargetResultToKotlin(getMountTargetPlain(argument.toJava()).await())

    /**
     * @see [getMountTarget].
     * @param accessPointId ID or ARN of the access point whose mount target that you want to find. It must be included if a `file_system_id` and `mount_target_id` are not included.
     * @param fileSystemId ID or ARN of the file system whose mount target that you want to find. It must be included if an `access_point_id` and `mount_target_id` are not included.
     * @param mountTargetId ID or ARN of the mount target that you want to find. It must be included in your request if an `access_point_id` and `file_system_id` are not included.
     * @return A collection of values returned by getMountTarget.
     */
    public suspend fun getMountTarget(
        accessPointId: String? = null,
        fileSystemId: String? = null,
        mountTargetId: String? = null,
    ): GetMountTargetResult {
        val argument = GetMountTargetPlainArgs(
            accessPointId = accessPointId,
            fileSystemId = fileSystemId,
            mountTargetId = mountTargetId,
        )
        return getMountTargetResultToKotlin(getMountTargetPlain(argument.toJava()).await())
    }

    /**
     * @see [getMountTarget].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;efs&#46;kotlin&#46;inputs&#46;GetMountTargetPlainArgs].
     * @return A collection of values returned by getMountTarget.
     */
    public suspend fun getMountTarget(argument: suspend GetMountTargetPlainArgsBuilder.() -> Unit):
        GetMountTargetResult {
        val builder = GetMountTargetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMountTargetResultToKotlin(getMountTargetPlain(builtArgument.toJava()).await())
    }
}
