@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.kotlin.outputs.FileSystemLifecyclePolicy
import com.pulumi.aws.efs.kotlin.outputs.FileSystemSizeInByte
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.efs.kotlin.outputs.FileSystemLifecyclePolicy.Companion.toKotlin as fileSystemLifecyclePolicyToKotlin
import com.pulumi.aws.efs.kotlin.outputs.FileSystemSizeInByte.Companion.toKotlin as fileSystemSizeInByteToKotlin

/**
 * Builder for [FileSystem].
 */
@PulumiTagMarker
public class FileSystemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FileSystemArgs = FileSystemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FileSystemArgsBuilder.() -> Unit) {
        val builder = FileSystemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FileSystem {
        val builtJavaResource = com.pulumi.aws.efs.FileSystem(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FileSystem(builtJavaResource)
    }
}

/**
 * Provides an Elastic File System (EFS) File System resource.
 * ## Example Usage
 * ### EFS File System w/ tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new FileSystem("foo", FileSystemArgs.builder()
 *             .tags(Map.of("Name", "MyProduct"))
 *             .build());
 *     }
 * }
 * ```
 * ### Using lifecycle policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.FileSystemArgs;
 * import com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooWithLifecylePolicy = new FileSystem("fooWithLifecylePolicy", FileSystemArgs.builder()
 *             .lifecyclePolicies(FileSystemLifecyclePolicyArgs.builder()
 *                 .transitionToIa("AFTER_30_DAYS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the EFS file systems using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:efs/fileSystem:FileSystem foo fs-6fa144c6
 * ```
 *
 */
public class FileSystem internal constructor(
    override val javaResource: com.pulumi.aws.efs.FileSystem,
) : KotlinCustomResource(javaResource, FileSystemMapper) {
    /**
     * Amazon Resource Name of the file system.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The identifier of the Availability Zone in which the file system's One Zone storage classes exist.
     */
    public val availabilityZoneId: Output<String>
        get() = javaResource.availabilityZoneId().applyValue({ args0 -> args0 })

    /**
     * the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
     */
    public val availabilityZoneName: Output<String>
        get() = javaResource.availabilityZoneName().applyValue({ args0 -> args0 })

    /**
     * A unique name (a maximum of 64 characters are allowed)
     * used as reference when creating the Elastic File System to ensure idempotent file
     * system creation. By default generated by this provider. See [Elastic File System]
     * user guide for more information.
     */
    public val creationToken: Output<String>
        get() = javaResource.creationToken().applyValue({ args0 -> args0 })

    /**
     * The DNS name for the filesystem per [documented convention](http://docs.aws.amazon.com/efs/latest/ug/mounting-fs-mount-cmd-dns-name.html).
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * If true, the disk will be encrypted.
     */
    public val encrypted: Output<Boolean>
        get() = javaResource.encrypted().applyValue({ args0 -> args0 })

    /**
     * The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
     */
    public val lifecyclePolicies: Output<List<FileSystemLifecyclePolicy>>?
        get() = javaResource.lifecyclePolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        fileSystemLifecyclePolicyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The value of the file system's `Name` tag.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current number of mount targets that the file system has.
     */
    public val numberOfMountTargets: Output<Int>
        get() = javaResource.numberOfMountTargets().applyValue({ args0 -> args0 })

    /**
     * The AWS account that created the file system. If the file system was createdby an IAM user, the parent account to which the user belongs is the owner.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
     */
    public val performanceMode: Output<String>
        get() = javaResource.performanceMode().applyValue({ args0 -> args0 })

    /**
     * The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
     */
    public val provisionedThroughputInMibps: Output<Double>?
        get() = javaResource.provisionedThroughputInMibps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The latest known metered size (in bytes) of data stored in the file system, the value is not the exact size that the file system was at any point in time. See Size In Bytes.
     */
    public val sizeInBytes: Output<List<FileSystemSizeInByte>>
        get() = javaResource.sizeInBytes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    fileSystemSizeInByteToKotlin(args0)
                })
            })
        })

    /**
     * A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`, or `elastic`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
     */
    public val throughputMode: Output<String>?
        get() = javaResource.throughputMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object FileSystemMapper : ResourceMapper<FileSystem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.efs.FileSystem::class == javaResource::class

    override fun map(javaResource: Resource): FileSystem = FileSystem(
        javaResource as
            com.pulumi.aws.efs.FileSystem,
    )
}

/**
 * @see [FileSystem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FileSystem].
 */
public suspend fun fileSystem(name: String, block: suspend FileSystemResourceBuilder.() -> Unit):
    FileSystem {
    val builder = FileSystemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FileSystem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fileSystem(name: String): FileSystem {
    val builder = FileSystemResourceBuilder()
    builder.name(name)
    return builder.build()
}
