@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.FileSystemArgs.builder
import com.pulumi.aws.efs.kotlin.inputs.FileSystemLifecyclePolicyArgs
import com.pulumi.aws.efs.kotlin.inputs.FileSystemLifecyclePolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic File System (EFS) File System resource.
 * ## Example Usage
 * ### EFS File System w/ tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new FileSystem("foo", FileSystemArgs.builder()
 *             .tags(Map.of("Name", "MyProduct"))
 *             .build());
 *     }
 * }
 * ```
 * ### Using lifecycle policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.FileSystemArgs;
 * import com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooWithLifecylePolicy = new FileSystem("fooWithLifecylePolicy", FileSystemArgs.builder()
 *             .lifecyclePolicies(FileSystemLifecyclePolicyArgs.builder()
 *                 .transitionToIa("AFTER_30_DAYS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the EFS file systems using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:efs/fileSystem:FileSystem foo fs-6fa144c6
 * ```
 * @property availabilityZoneName the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
 * @property creationToken A unique name (a maximum of 64 characters are allowed)
 * used as reference when creating the Elastic File System to ensure idempotent file
 * system creation. By default generated by this provider. See [Elastic File System]
 * user guide for more information.
 * @property encrypted If true, the disk will be encrypted.
 * @property kmsKeyId The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
 * @property lifecyclePolicies A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
 * @property performanceMode The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
 * @property provisionedThroughputInMibps The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
 * @property tags A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property throughputMode Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`, or `elastic`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
 */
public data class FileSystemArgs(
    public val availabilityZoneName: Output<String>? = null,
    public val creationToken: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val lifecyclePolicies: Output<List<FileSystemLifecyclePolicyArgs>>? = null,
    public val performanceMode: Output<String>? = null,
    public val provisionedThroughputInMibps: Output<Double>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throughputMode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.FileSystemArgs> {
    override fun toJava(): com.pulumi.aws.efs.FileSystemArgs =
        com.pulumi.aws.efs.FileSystemArgs.builder()
            .availabilityZoneName(availabilityZoneName?.applyValue({ args0 -> args0 }))
            .creationToken(creationToken?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .lifecyclePolicies(
                lifecyclePolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .performanceMode(performanceMode?.applyValue({ args0 -> args0 }))
            .provisionedThroughputInMibps(provisionedThroughputInMibps?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throughputMode(throughputMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileSystemArgs].
 */
@PulumiTagMarker
public class FileSystemArgsBuilder internal constructor() {
    private var availabilityZoneName: Output<String>? = null

    private var creationToken: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var kmsKeyId: Output<String>? = null

    private var lifecyclePolicies: Output<List<FileSystemLifecyclePolicyArgs>>? = null

    private var performanceMode: Output<String>? = null

    private var provisionedThroughputInMibps: Output<Double>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throughputMode: Output<String>? = null

    /**
     * @param value the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
     */
    @JvmName("ewxrgidhxxdothti")
    public suspend fun availabilityZoneName(`value`: Output<String>) {
        this.availabilityZoneName = value
    }

    /**
     * @param value A unique name (a maximum of 64 characters are allowed)
     * used as reference when creating the Elastic File System to ensure idempotent file
     * system creation. By default generated by this provider. See [Elastic File System]
     * user guide for more information.
     */
    @JvmName("txhmkyatsgvntamt")
    public suspend fun creationToken(`value`: Output<String>) {
        this.creationToken = value
    }

    /**
     * @param value If true, the disk will be encrypted.
     */
    @JvmName("hvekpayogbdfgwsw")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
     */
    @JvmName("ajhxcuxjltjvjjij")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
     */
    @JvmName("iwkkpxfojlabvqev")
    public suspend fun lifecyclePolicies(`value`: Output<List<FileSystemLifecyclePolicyArgs>>) {
        this.lifecyclePolicies = value
    }

    @JvmName("onpgeaqrwvmthsga")
    public suspend fun lifecyclePolicies(vararg values: Output<FileSystemLifecyclePolicyArgs>) {
        this.lifecyclePolicies = Output.all(values.asList())
    }

    /**
     * @param values A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
     */
    @JvmName("gcjnihmwxhuymgad")
    public suspend fun lifecyclePolicies(values: List<Output<FileSystemLifecyclePolicyArgs>>) {
        this.lifecyclePolicies = Output.all(values)
    }

    /**
     * @param value The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
     */
    @JvmName("mqxxpkdsxllfsbja")
    public suspend fun performanceMode(`value`: Output<String>) {
        this.performanceMode = value
    }

    /**
     * @param value The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
     */
    @JvmName("jxsftmkokyxmgyng")
    public suspend fun provisionedThroughputInMibps(`value`: Output<Double>) {
        this.provisionedThroughputInMibps = value
    }

    /**
     * @param value A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fkauqehurbltglff")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`, or `elastic`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
     */
    @JvmName("sevakgqgrpjvhmpx")
    public suspend fun throughputMode(`value`: Output<String>) {
        this.throughputMode = value
    }

    /**
     * @param value the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
     */
    @JvmName("vmvrdowgieubdvvc")
    public suspend fun availabilityZoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZoneName = mapped
    }

    /**
     * @param value A unique name (a maximum of 64 characters are allowed)
     * used as reference when creating the Elastic File System to ensure idempotent file
     * system creation. By default generated by this provider. See [Elastic File System]
     * user guide for more information.
     */
    @JvmName("kpaiqvimhmfesvwn")
    public suspend fun creationToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationToken = mapped
    }

    /**
     * @param value If true, the disk will be encrypted.
     */
    @JvmName("aogqqfuoxergoqnx")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
     */
    @JvmName("iywlgcophgcxsova")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
     */
    @JvmName("wwmwqccotcsbtwjd")
    public suspend fun lifecyclePolicies(`value`: List<FileSystemLifecyclePolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecyclePolicies = mapped
    }

    /**
     * @param argument A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
     */
    @JvmName("cyxfnkenujwtgsbq")
    public suspend
    fun lifecyclePolicies(argument: List<suspend FileSystemLifecyclePolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FileSystemLifecyclePolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecyclePolicies = mapped
    }

    /**
     * @param argument A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
     */
    @JvmName("xqpteshliiqckosg")
    public suspend fun lifecyclePolicies(
        vararg
        argument: suspend FileSystemLifecyclePolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FileSystemLifecyclePolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecyclePolicies = mapped
    }

    /**
     * @param argument A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
     */
    @JvmName("rhroycfyfijymvhe")
    public suspend
    fun lifecyclePolicies(argument: suspend FileSystemLifecyclePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FileSystemLifecyclePolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.lifecyclePolicies = mapped
    }

    /**
     * @param values A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
     */
    @JvmName("lqyfrjvtwvnkntju")
    public suspend fun lifecyclePolicies(vararg values: FileSystemLifecyclePolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecyclePolicies = mapped
    }

    /**
     * @param value The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
     */
    @JvmName("baaftgwryegbliyr")
    public suspend fun performanceMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceMode = mapped
    }

    /**
     * @param value The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
     */
    @JvmName("wctlxqucbfshbisa")
    public suspend fun provisionedThroughputInMibps(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedThroughputInMibps = mapped
    }

    /**
     * @param value A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iknfvrqoiitsdwmq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("joglnhetwjxicblr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`, or `elastic`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
     */
    @JvmName("vfrqygnhadqoxnek")
    public suspend fun throughputMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputMode = mapped
    }

    internal fun build(): FileSystemArgs = FileSystemArgs(
        availabilityZoneName = availabilityZoneName,
        creationToken = creationToken,
        encrypted = encrypted,
        kmsKeyId = kmsKeyId,
        lifecyclePolicies = lifecyclePolicies,
        performanceMode = performanceMode,
        provisionedThroughputInMibps = provisionedThroughputInMibps,
        tags = tags,
        throughputMode = throughputMode,
    )
}
