@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FileSystemPolicy].
 */
@PulumiTagMarker
public class FileSystemPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FileSystemPolicyArgs = FileSystemPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FileSystemPolicyArgsBuilder.() -> Unit) {
        val builder = FileSystemPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FileSystemPolicy {
        val builtJavaResource = com.pulumi.aws.efs.FileSystemPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FileSystemPolicy(builtJavaResource)
    }
}

/**
 * Provides an Elastic File System (EFS) File System Policy resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.efs.FileSystemPolicy;
 * import com.pulumi.aws.efs.FileSystemPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fs = new FileSystem("fs");
 *         final var policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("ExampleStatement01")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions(
 *                     "elasticfilesystem:ClientMount",
 *                     "elasticfilesystem:ClientWrite")
 *                 .resources(fs.arn())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("Bool")
 *                     .variable("aws:SecureTransport")
 *                     .values("true")
 *                     .build())
 *                 .build())
 *             .build());
 *         var policyFileSystemPolicy = new FileSystemPolicy("policyFileSystemPolicy", FileSystemPolicyArgs.builder()
 *             .fileSystemId(fs.id())
 *             .policy(policyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(policyPolicyDocument -> policyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the EFS file system policies using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:efs/fileSystemPolicy:FileSystemPolicy foo fs-6fa144c6
 * ```
 *
 */
public class FileSystemPolicy internal constructor(
    override val javaResource: com.pulumi.aws.efs.FileSystemPolicy,
) : KotlinCustomResource(javaResource, FileSystemPolicyMapper) {
    /**
     * A flag to indicate whether to bypass the `aws.efs.FileSystemPolicy` lockout safety check. The policy lockout safety check determines whether the policy in the request will prevent the principal making the request will be locked out from making future `PutFileSystemPolicy` requests on the file system. Set `bypass_policy_lockout_safety_check` to `true` only when you intend to prevent the principal that is making the request from making a subsequent `PutFileSystemPolicy` request on the file system. The default value is `false`.
     */
    public val bypassPolicyLockoutSafetyCheck: Output<Boolean>?
        get() = javaResource.bypassPolicyLockoutSafetyCheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the EFS file system.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * The JSON formatted file system policy for the EFS file system. see [Docs](https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies) for more info.
     * The following arguments are optional:
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object FileSystemPolicyMapper : ResourceMapper<FileSystemPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.efs.FileSystemPolicy::class == javaResource::class

    override fun map(javaResource: Resource): FileSystemPolicy = FileSystemPolicy(
        javaResource as
            com.pulumi.aws.efs.FileSystemPolicy,
    )
}

/**
 * @see [FileSystemPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FileSystemPolicy].
 */
public suspend fun fileSystemPolicy(
    name: String,
    block: suspend FileSystemPolicyResourceBuilder.() -> Unit,
): FileSystemPolicy {
    val builder = FileSystemPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FileSystemPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fileSystemPolicy(name: String): FileSystemPolicy {
    val builder = FileSystemPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
