@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [MountTarget].
 */
@PulumiTagMarker
public class MountTargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MountTargetArgs = MountTargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MountTargetArgsBuilder.() -> Unit) {
        val builder = MountTargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MountTarget {
        val builtJavaResource = com.pulumi.aws.efs.MountTarget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MountTarget(builtJavaResource)
    }
}

/**
 * Provides an Elastic File System (EFS) mount target.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.efs.MountTarget;
 * import com.pulumi.aws.efs.MountTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Vpc("foo", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var alphaSubnet = new Subnet("alphaSubnet", SubnetArgs.builder()
 *             .vpcId(foo.id())
 *             .availabilityZone("us-west-2a")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var alphaMountTarget = new MountTarget("alphaMountTarget", MountTargetArgs.builder()
 *             .fileSystemId(aws_efs_file_system.foo().id())
 *             .subnetId(alphaSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the EFS mount targets using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:efs/mountTarget:MountTarget alpha fsmt-52a643fb
 * ```
 *
 */
public class MountTarget internal constructor(
    override val javaResource: com.pulumi.aws.efs.MountTarget,
) : KotlinCustomResource(javaResource, MountTargetMapper) {
    /**
     * The unique and consistent identifier of the Availability Zone (AZ) that the mount target resides in.
     */
    public val availabilityZoneId: Output<String>
        get() = javaResource.availabilityZoneId().applyValue({ args0 -> args0 })

    /**
     * The name of the Availability Zone (AZ) that the mount target resides in.
     */
    public val availabilityZoneName: Output<String>
        get() = javaResource.availabilityZoneName().applyValue({ args0 -> args0 })

    /**
     * The DNS name for the EFS file system.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name of the file system.
     */
    public val fileSystemArn: Output<String>
        get() = javaResource.fileSystemArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the file system for which the mount target is intended.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * The address (within the address range of the specified subnet) at
     * which the file system may be mounted via the mount target.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * The DNS name for the given subnet/AZ per [documented convention](http://docs.aws.amazon.com/efs/latest/ug/mounting-fs-mount-cmd-dns-name.html).
     */
    public val mountTargetDnsName: Output<String>
        get() = javaResource.mountTargetDnsName().applyValue({ args0 -> args0 })

    /**
     * The ID of the network interface that Amazon EFS created when it created the mount target.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * AWS account ID that owns the resource.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A list of up to 5 VPC security group IDs (that must
     * be for the same VPC as subnet specified) in effect for the mount target.
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the subnet to add the mount target in.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })
}

public object MountTargetMapper : ResourceMapper<MountTarget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.efs.MountTarget::class == javaResource::class

    override fun map(javaResource: Resource): MountTarget = MountTarget(
        javaResource as
            com.pulumi.aws.efs.MountTarget,
    )
}

/**
 * @see [MountTarget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MountTarget].
 */
public suspend fun mountTarget(name: String, block: suspend MountTargetResourceBuilder.() -> Unit):
    MountTarget {
    val builder = MountTargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MountTarget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mountTarget(name: String): MountTarget {
    val builder = MountTargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
