@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.MountTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Elastic File System (EFS) mount target.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.efs.MountTarget;
 * import com.pulumi.aws.efs.MountTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Vpc("foo", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var alphaSubnet = new Subnet("alphaSubnet", SubnetArgs.builder()
 *             .vpcId(foo.id())
 *             .availabilityZone("us-west-2a")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var alphaMountTarget = new MountTarget("alphaMountTarget", MountTargetArgs.builder()
 *             .fileSystemId(aws_efs_file_system.foo().id())
 *             .subnetId(alphaSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the EFS mount targets using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:efs/mountTarget:MountTarget alpha fsmt-52a643fb
 * ```
 * @property fileSystemId The ID of the file system for which the mount target is intended.
 * @property ipAddress The address (within the address range of the specified subnet) at
 * which the file system may be mounted via the mount target.
 * @property securityGroups A list of up to 5 VPC security group IDs (that must
 * be for the same VPC as subnet specified) in effect for the mount target.
 * @property subnetId The ID of the subnet to add the mount target in.
 */
public data class MountTargetArgs(
    public val fileSystemId: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.MountTargetArgs> {
    override fun toJava(): com.pulumi.aws.efs.MountTargetArgs =
        com.pulumi.aws.efs.MountTargetArgs.builder()
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MountTargetArgs].
 */
@PulumiTagMarker
public class MountTargetArgsBuilder internal constructor() {
    private var fileSystemId: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The ID of the file system for which the mount target is intended.
     */
    @JvmName("lxmvoajpdxvovbxm")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The address (within the address range of the specified subnet) at
     * which the file system may be mounted via the mount target.
     */
    @JvmName("ogotmopwpnufyyac")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value A list of up to 5 VPC security group IDs (that must
     * be for the same VPC as subnet specified) in effect for the mount target.
     */
    @JvmName("ljmvsnrjnuguofhf")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("jidggleidtoumheg")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of up to 5 VPC security group IDs (that must
     * be for the same VPC as subnet specified) in effect for the mount target.
     */
    @JvmName("cclufvsylvssgwpi")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The ID of the subnet to add the mount target in.
     */
    @JvmName("dtrdssqkksjuklyq")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The ID of the file system for which the mount target is intended.
     */
    @JvmName("trubushcxbatfurt")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The address (within the address range of the specified subnet) at
     * which the file system may be mounted via the mount target.
     */
    @JvmName("hiyxvylgverotrxi")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value A list of up to 5 VPC security group IDs (that must
     * be for the same VPC as subnet specified) in effect for the mount target.
     */
    @JvmName("hkitrethopthdfrs")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of up to 5 VPC security group IDs (that must
     * be for the same VPC as subnet specified) in effect for the mount target.
     */
    @JvmName("hnvraaupjntbbtpn")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The ID of the subnet to add the mount target in.
     */
    @JvmName("hpmhwjsvwpiytyns")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): MountTargetArgs = MountTargetArgs(
        fileSystemId = fileSystemId,
        ipAddress = ipAddress,
        securityGroups = securityGroups,
        subnetId = subnetId,
    )
}
