@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.kotlin.outputs.ReplicationConfigurationDestination
import com.pulumi.aws.efs.kotlin.outputs.ReplicationConfigurationDestination.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationConfiguration].
 */
@PulumiTagMarker
public class ReplicationConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationConfigurationArgs = ReplicationConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationConfigurationArgsBuilder.() -> Unit) {
        val builder = ReplicationConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationConfiguration {
        val builtJavaResource = com.pulumi.aws.efs.ReplicationConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicationConfiguration(builtJavaResource)
    }
}

/**
 * Creates a replica of an existing EFS file system in the same or another region. Creating this resource causes the source EFS file system to be replicated to a new read-only destination EFS file system. Deleting this resource will cause the replication from source to destination to stop and the destination file system will no longer be read only.
 * > **NOTE:** Deleting this resource does **not** delete the destination file system that was created.
 * ## Example Usage
 * Will create a replica using regional storage in us-west-2 that will be encrypted by the default EFS KMS key `/aws/elasticfilesystem`.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.ReplicationConfiguration;
 * import com.pulumi.aws.efs.ReplicationConfigurationArgs;
 * import com.pulumi.aws.efs.inputs.ReplicationConfigurationDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleFileSystem = new FileSystem("exampleFileSystem");
 *         var exampleReplicationConfiguration = new ReplicationConfiguration("exampleReplicationConfiguration", ReplicationConfigurationArgs.builder()
 *             .sourceFileSystemId(exampleFileSystem.id())
 *             .destination(ReplicationConfigurationDestinationArgs.builder()
 *                 .region("us-west-2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EFS Replication Configurations using the file system ID of either the source or destination file system. When importing, the `availability_zone_name` and `kms_key_id` attributes must __not__ be set in the configuration. The AWS API does not return these values when querying the replication configuration and their presence will therefore show as a diff in a subsequent plan. For example:
 * ```sh
 *  $ pulumi import aws:efs/replicationConfiguration:ReplicationConfiguration example fs-id
 * ```
 *
 */
public class ReplicationConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.efs.ReplicationConfiguration,
) : KotlinCustomResource(javaResource, ReplicationConfigurationMapper) {
    /**
     * When the replication configuration was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * A destination configuration block (documented below).
     */
    public val destination: Output<ReplicationConfigurationDestination>
        get() = javaResource.destination().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The Amazon Resource Name (ARN) of the original source Amazon EFS file system in the replication configuration.
     */
    public val originalSourceFileSystemArn: Output<String>
        get() = javaResource.originalSourceFileSystemArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the current source file system in the replication configuration.
     */
    public val sourceFileSystemArn: Output<String>
        get() = javaResource.sourceFileSystemArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the file system that is to be replicated.
     */
    public val sourceFileSystemId: Output<String>
        get() = javaResource.sourceFileSystemId().applyValue({ args0 -> args0 })

    /**
     * The AWS Region in which the source Amazon EFS file system is located.
     * * `destination[0].file_system_id` - The fs ID of the replica.
     * * `destination[0].status` - The status of the replication.
     */
    public val sourceFileSystemRegion: Output<String>
        get() = javaResource.sourceFileSystemRegion().applyValue({ args0 -> args0 })
}

public object ReplicationConfigurationMapper : ResourceMapper<ReplicationConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.efs.ReplicationConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationConfiguration =
        ReplicationConfiguration(javaResource as com.pulumi.aws.efs.ReplicationConfiguration)
}

/**
 * @see [ReplicationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationConfiguration].
 */
public suspend fun replicationConfiguration(
    name: String,
    block: suspend ReplicationConfigurationResourceBuilder.() -> Unit,
): ReplicationConfiguration {
    val builder = ReplicationConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationConfiguration(name: String): ReplicationConfiguration {
    val builder = ReplicationConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
