@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.ReplicationConfigurationArgs.builder
import com.pulumi.aws.efs.kotlin.inputs.ReplicationConfigurationDestinationArgs
import com.pulumi.aws.efs.kotlin.inputs.ReplicationConfigurationDestinationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Creates a replica of an existing EFS file system in the same or another region. Creating this resource causes the source EFS file system to be replicated to a new read-only destination EFS file system. Deleting this resource will cause the replication from source to destination to stop and the destination file system will no longer be read only.
 * > **NOTE:** Deleting this resource does **not** delete the destination file system that was created.
 * ## Example Usage
 * Will create a replica using regional storage in us-west-2 that will be encrypted by the default EFS KMS key `/aws/elasticfilesystem`.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.ReplicationConfiguration;
 * import com.pulumi.aws.efs.ReplicationConfigurationArgs;
 * import com.pulumi.aws.efs.inputs.ReplicationConfigurationDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleFileSystem = new FileSystem("exampleFileSystem");
 *         var exampleReplicationConfiguration = new ReplicationConfiguration("exampleReplicationConfiguration", ReplicationConfigurationArgs.builder()
 *             .sourceFileSystemId(exampleFileSystem.id())
 *             .destination(ReplicationConfigurationDestinationArgs.builder()
 *                 .region("us-west-2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EFS Replication Configurations using the file system ID of either the source or destination file system. When importing, the `availability_zone_name` and `kms_key_id` attributes must __not__ be set in the configuration. The AWS API does not return these values when querying the replication configuration and their presence will therefore show as a diff in a subsequent plan. For example:
 * ```sh
 *  $ pulumi import aws:efs/replicationConfiguration:ReplicationConfiguration example fs-id
 * ```
 * @property destination A destination configuration block (documented below).
 * @property sourceFileSystemId The ID of the file system that is to be replicated.
 */
public data class ReplicationConfigurationArgs(
    public val destination: Output<ReplicationConfigurationDestinationArgs>? = null,
    public val sourceFileSystemId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.ReplicationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.efs.ReplicationConfigurationArgs =
        com.pulumi.aws.efs.ReplicationConfigurationArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceFileSystemId(sourceFileSystemId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationConfigurationArgs].
 */
@PulumiTagMarker
public class ReplicationConfigurationArgsBuilder internal constructor() {
    private var destination: Output<ReplicationConfigurationDestinationArgs>? = null

    private var sourceFileSystemId: Output<String>? = null

    /**
     * @param value A destination configuration block (documented below).
     */
    @JvmName("mlmawocyomerggft")
    public suspend fun destination(`value`: Output<ReplicationConfigurationDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value The ID of the file system that is to be replicated.
     */
    @JvmName("lvekkunlteajjnlg")
    public suspend fun sourceFileSystemId(`value`: Output<String>) {
        this.sourceFileSystemId = value
    }

    /**
     * @param value A destination configuration block (documented below).
     */
    @JvmName("pjckdxycofrpcoge")
    public suspend fun destination(`value`: ReplicationConfigurationDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument A destination configuration block (documented below).
     */
    @JvmName("rytsfajhblkaqjyw")
    public suspend
    fun destination(argument: suspend ReplicationConfigurationDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ReplicationConfigurationDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value The ID of the file system that is to be replicated.
     */
    @JvmName("urkgdeawnjpfhmlj")
    public suspend fun sourceFileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceFileSystemId = mapped
    }

    internal fun build(): ReplicationConfigurationArgs = ReplicationConfigurationArgs(
        destination = destination,
        sourceFileSystemId = sourceFileSystemId,
    )
}
