@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.AccessPointPosixUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property gid POSIX group ID used for all file system operations using this access point.
 * @property secondaryGids Secondary POSIX group IDs used for all file system operations using this access point.
 * @property uid POSIX user ID used for all file system operations using this access point.
 */
public data class AccessPointPosixUserArgs(
    public val gid: Output<Int>,
    public val secondaryGids: Output<List<Int>>? = null,
    public val uid: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.AccessPointPosixUserArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.AccessPointPosixUserArgs =
        com.pulumi.aws.efs.inputs.AccessPointPosixUserArgs.builder()
            .gid(gid.applyValue({ args0 -> args0 }))
            .secondaryGids(secondaryGids?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .uid(uid.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPointPosixUserArgs].
 */
@PulumiTagMarker
public class AccessPointPosixUserArgsBuilder internal constructor() {
    private var gid: Output<Int>? = null

    private var secondaryGids: Output<List<Int>>? = null

    private var uid: Output<Int>? = null

    /**
     * @param value POSIX group ID used for all file system operations using this access point.
     */
    @JvmName("fcpufuxwiaohelov")
    public suspend fun gid(`value`: Output<Int>) {
        this.gid = value
    }

    /**
     * @param value Secondary POSIX group IDs used for all file system operations using this access point.
     */
    @JvmName("qfnhwtypnqedhudv")
    public suspend fun secondaryGids(`value`: Output<List<Int>>) {
        this.secondaryGids = value
    }

    @JvmName("xagasiuxqxtkcdmq")
    public suspend fun secondaryGids(vararg values: Output<Int>) {
        this.secondaryGids = Output.all(values.asList())
    }

    /**
     * @param values Secondary POSIX group IDs used for all file system operations using this access point.
     */
    @JvmName("dcxcbwssufebcecy")
    public suspend fun secondaryGids(values: List<Output<Int>>) {
        this.secondaryGids = Output.all(values)
    }

    /**
     * @param value POSIX user ID used for all file system operations using this access point.
     */
    @JvmName("bhcpmhqsffkqthkq")
    public suspend fun uid(`value`: Output<Int>) {
        this.uid = value
    }

    /**
     * @param value POSIX group ID used for all file system operations using this access point.
     */
    @JvmName("sssvtecspjoqthpj")
    public suspend fun gid(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gid = mapped
    }

    /**
     * @param value Secondary POSIX group IDs used for all file system operations using this access point.
     */
    @JvmName("ocgblqlfiyeescxv")
    public suspend fun secondaryGids(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryGids = mapped
    }

    /**
     * @param values Secondary POSIX group IDs used for all file system operations using this access point.
     */
    @JvmName("qfinucbrltguirdu")
    public suspend fun secondaryGids(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryGids = mapped
    }

    /**
     * @param value POSIX user ID used for all file system operations using this access point.
     */
    @JvmName("turnyqrtkkgkbnrc")
    public suspend fun uid(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uid = mapped
    }

    internal fun build(): AccessPointPosixUserArgs = AccessPointPosixUserArgs(
        gid = gid ?: throw PulumiNullFieldException("gid"),
        secondaryGids = secondaryGids,
        uid = uid ?: throw PulumiNullFieldException("uid"),
    )
}
