@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.AccessPointRootDirectoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property creationInfo POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
 * @property path Path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide `creation_info`.
 */
public data class AccessPointRootDirectoryArgs(
    public val creationInfo: Output<AccessPointRootDirectoryCreationInfoArgs>? = null,
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.AccessPointRootDirectoryArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.AccessPointRootDirectoryArgs =
        com.pulumi.aws.efs.inputs.AccessPointRootDirectoryArgs.builder()
            .creationInfo(creationInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPointRootDirectoryArgs].
 */
@PulumiTagMarker
public class AccessPointRootDirectoryArgsBuilder internal constructor() {
    private var creationInfo: Output<AccessPointRootDirectoryCreationInfoArgs>? = null

    private var path: Output<String>? = null

    /**
     * @param value POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
     */
    @JvmName("ulwkdxsbjqvabebl")
    public suspend fun creationInfo(`value`: Output<AccessPointRootDirectoryCreationInfoArgs>) {
        this.creationInfo = value
    }

    /**
     * @param value Path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide `creation_info`.
     */
    @JvmName("fewpsicarbvtbkef")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
     */
    @JvmName("tfvyhdrahasjinxc")
    public suspend fun creationInfo(`value`: AccessPointRootDirectoryCreationInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationInfo = mapped
    }

    /**
     * @param argument POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
     */
    @JvmName("jkrkaptrebxqvdps")
    public suspend
    fun creationInfo(argument: suspend AccessPointRootDirectoryCreationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPointRootDirectoryCreationInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.creationInfo = mapped
    }

    /**
     * @param value Path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide `creation_info`.
     */
    @JvmName("hbbgmtqcjbdanggi")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): AccessPointRootDirectoryArgs = AccessPointRootDirectoryArgs(
        creationInfo = creationInfo,
        path = path,
    )
}
