@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.AccessPointRootDirectoryCreationInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ownerGid POSIX group ID to apply to the `root_directory`.
 * @property ownerUid POSIX user ID to apply to the `root_directory`.
 * @property permissions POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
 */
public data class AccessPointRootDirectoryCreationInfoArgs(
    public val ownerGid: Output<Int>,
    public val ownerUid: Output<Int>,
    public val permissions: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.AccessPointRootDirectoryCreationInfoArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.AccessPointRootDirectoryCreationInfoArgs =
        com.pulumi.aws.efs.inputs.AccessPointRootDirectoryCreationInfoArgs.builder()
            .ownerGid(ownerGid.applyValue({ args0 -> args0 }))
            .ownerUid(ownerUid.applyValue({ args0 -> args0 }))
            .permissions(permissions.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPointRootDirectoryCreationInfoArgs].
 */
@PulumiTagMarker
public class AccessPointRootDirectoryCreationInfoArgsBuilder internal constructor() {
    private var ownerGid: Output<Int>? = null

    private var ownerUid: Output<Int>? = null

    private var permissions: Output<String>? = null

    /**
     * @param value POSIX group ID to apply to the `root_directory`.
     */
    @JvmName("ilvaeubomiwrnswa")
    public suspend fun ownerGid(`value`: Output<Int>) {
        this.ownerGid = value
    }

    /**
     * @param value POSIX user ID to apply to the `root_directory`.
     */
    @JvmName("isxqqubtqycvkylc")
    public suspend fun ownerUid(`value`: Output<Int>) {
        this.ownerUid = value
    }

    /**
     * @param value POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
     */
    @JvmName("pfmeomunorixggla")
    public suspend fun permissions(`value`: Output<String>) {
        this.permissions = value
    }

    /**
     * @param value POSIX group ID to apply to the `root_directory`.
     */
    @JvmName("ckebtjorbmmaftwn")
    public suspend fun ownerGid(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownerGid = mapped
    }

    /**
     * @param value POSIX user ID to apply to the `root_directory`.
     */
    @JvmName("cebmkhtrarcwdlfk")
    public suspend fun ownerUid(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownerUid = mapped
    }

    /**
     * @param value POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
     */
    @JvmName("rstwjxrurdgpcfrk")
    public suspend fun permissions(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    internal fun build(): AccessPointRootDirectoryCreationInfoArgs =
        AccessPointRootDirectoryCreationInfoArgs(
            ownerGid = ownerGid ?: throw PulumiNullFieldException("ownerGid"),
            ownerUid = ownerUid ?: throw PulumiNullFieldException("ownerUid"),
            permissions = permissions ?: throw PulumiNullFieldException("permissions"),
        )
}
