@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.BackupPolicyBackupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status A status of the backup policy. Valid values: `ENABLED`, `DISABLED`.
 */
public data class BackupPolicyBackupPolicyArgs(
    public val status: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.BackupPolicyBackupPolicyArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.BackupPolicyBackupPolicyArgs =
        com.pulumi.aws.efs.inputs.BackupPolicyBackupPolicyArgs.builder()
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupPolicyBackupPolicyArgs].
 */
@PulumiTagMarker
public class BackupPolicyBackupPolicyArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value A status of the backup policy. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("nfmpngrcqjnxbvnf")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A status of the backup policy. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("ncteabvkvjhboohs")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BackupPolicyBackupPolicyArgs = BackupPolicyBackupPolicyArgs(
        status = status ?: throw PulumiNullFieldException("status"),
    )
}
