@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property transitionToIa Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, or `AFTER_90_DAYS`.
 * @property transitionToPrimaryStorageClass Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
 */
public data class FileSystemLifecyclePolicyArgs(
    public val transitionToIa: Output<String>? = null,
    public val transitionToPrimaryStorageClass: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs =
        com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs.builder()
            .transitionToIa(transitionToIa?.applyValue({ args0 -> args0 }))
            .transitionToPrimaryStorageClass(
                transitionToPrimaryStorageClass?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [FileSystemLifecyclePolicyArgs].
 */
@PulumiTagMarker
public class FileSystemLifecyclePolicyArgsBuilder internal constructor() {
    private var transitionToIa: Output<String>? = null

    private var transitionToPrimaryStorageClass: Output<String>? = null

    /**
     * @param value Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, or `AFTER_90_DAYS`.
     */
    @JvmName("rbltcxlspchrfyhs")
    public suspend fun transitionToIa(`value`: Output<String>) {
        this.transitionToIa = value
    }

    /**
     * @param value Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
     */
    @JvmName("rvcvxqpkfrpmxllo")
    public suspend fun transitionToPrimaryStorageClass(`value`: Output<String>) {
        this.transitionToPrimaryStorageClass = value
    }

    /**
     * @param value Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, or `AFTER_90_DAYS`.
     */
    @JvmName("weuyvupqsaykljxn")
    public suspend fun transitionToIa(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitionToIa = mapped
    }

    /**
     * @param value Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
     */
    @JvmName("bcamrdnewgnwyqgt")
    public suspend fun transitionToPrimaryStorageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitionToPrimaryStorageClass = mapped
    }

    internal fun build(): FileSystemLifecyclePolicyArgs = FileSystemLifecyclePolicyArgs(
        transitionToIa = transitionToIa,
        transitionToPrimaryStorageClass = transitionToPrimaryStorageClass,
    )
}
