@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.GetAccessPointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessPoint.
 * @property accessPointId ID that identifies the file system.
 * @property tags Key-value mapping of resource tags.
 */
public data class GetAccessPointPlainArgs(
    public val accessPointId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.GetAccessPointPlainArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.GetAccessPointPlainArgs =
        com.pulumi.aws.efs.inputs.GetAccessPointPlainArgs.builder()
            .accessPointId(accessPointId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetAccessPointPlainArgs].
 */
@PulumiTagMarker
public class GetAccessPointPlainArgsBuilder internal constructor() {
    private var accessPointId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID that identifies the file system.
     */
    @JvmName("owreclkonfigmylq")
    public suspend fun accessPointId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessPointId = mapped
    }

    /**
     * @param value Key-value mapping of resource tags.
     */
    @JvmName("pokyflqchkgfuria")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags.
     */
    @JvmName("aevtntrsydyxevyq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetAccessPointPlainArgs = GetAccessPointPlainArgs(
        accessPointId = accessPointId ?: throw PulumiNullFieldException("accessPointId"),
        tags = tags,
    )
}
