@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.ReplicationConfigurationDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZoneName The availability zone in which the replica should be created. If specified, the replica will be created with One Zone storage. If omitted, regional storage will be used.
 * @property fileSystemId
 * @property kmsKeyId The Key ID, ARN, alias, or alias ARN of the KMS key that should be used to encrypt the replica file system. If omitted, the default KMS key for EFS `/aws/elasticfilesystem` will be used.
 * @property region The region in which the replica should be created.
 * @property status
 */
public data class ReplicationConfigurationDestinationArgs(
    public val availabilityZoneName: Output<String>? = null,
    public val fileSystemId: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val region: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.ReplicationConfigurationDestinationArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.ReplicationConfigurationDestinationArgs =
        com.pulumi.aws.efs.inputs.ReplicationConfigurationDestinationArgs.builder()
            .availabilityZoneName(availabilityZoneName?.applyValue({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationConfigurationDestinationArgs].
 */
@PulumiTagMarker
public class ReplicationConfigurationDestinationArgsBuilder internal constructor() {
    private var availabilityZoneName: Output<String>? = null

    private var fileSystemId: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var region: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The availability zone in which the replica should be created. If specified, the replica will be created with One Zone storage. If omitted, regional storage will be used.
     */
    @JvmName("gurgbgjrvxomvobk")
    public suspend fun availabilityZoneName(`value`: Output<String>) {
        this.availabilityZoneName = value
    }

    /**
     * @param value
     */
    @JvmName("opicptnilytpaoim")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The Key ID, ARN, alias, or alias ARN of the KMS key that should be used to encrypt the replica file system. If omitted, the default KMS key for EFS `/aws/elasticfilesystem` will be used.
     */
    @JvmName("gdpdvtchrrhsvair")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The region in which the replica should be created.
     */
    @JvmName("offfuvjtlixqfmuc")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value
     */
    @JvmName("dydcyxxyxqxuxiok")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The availability zone in which the replica should be created. If specified, the replica will be created with One Zone storage. If omitted, regional storage will be used.
     */
    @JvmName("xakahuqxrnukcbly")
    public suspend fun availabilityZoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZoneName = mapped
    }

    /**
     * @param value
     */
    @JvmName("uxynbyiylxxifime")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The Key ID, ARN, alias, or alias ARN of the KMS key that should be used to encrypt the replica file system. If omitted, the default KMS key for EFS `/aws/elasticfilesystem` will be used.
     */
    @JvmName("qoslmscanflodkrc")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The region in which the replica should be created.
     */
    @JvmName("tnaftqxqpmocvafs")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value
     */
    @JvmName("pimcuttbvjxmumsk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ReplicationConfigurationDestinationArgs =
        ReplicationConfigurationDestinationArgs(
            availabilityZoneName = availabilityZoneName,
            fileSystemId = fileSystemId,
            kmsKeyId = kmsKeyId,
            region = region,
            status = status,
        )
}
