@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ownerGid POSIX group ID to apply to the `root_directory`.
 * @property ownerUid POSIX user ID to apply to the `root_directory`.
 * @property permissions POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
 */
public data class AccessPointRootDirectoryCreationInfo(
    public val ownerGid: Int,
    public val ownerUid: Int,
    public val permissions: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.AccessPointRootDirectoryCreationInfo):
            AccessPointRootDirectoryCreationInfo = AccessPointRootDirectoryCreationInfo(
            ownerGid = javaType.ownerGid(),
            ownerUid = javaType.ownerUid(),
            permissions = javaType.permissions(),
        )
    }
}
