@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property transitionToIa Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, or `AFTER_90_DAYS`.
 * @property transitionToPrimaryStorageClass Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
 */
public data class FileSystemLifecyclePolicy(
    public val transitionToIa: String? = null,
    public val transitionToPrimaryStorageClass: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.FileSystemLifecyclePolicy):
            FileSystemLifecyclePolicy = FileSystemLifecyclePolicy(
            transitionToIa = javaType.transitionToIa().map({ args0 -> args0 }).orElse(null),
            transitionToPrimaryStorageClass = javaType.transitionToPrimaryStorageClass().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
