@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property gid Group ID
 * @property secondaryGids Secondary group IDs
 * @property uid User Id
 */
public data class GetAccessPointPosixUser(
    public val gid: Int,
    public val secondaryGids: List<Int>,
    public val uid: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.GetAccessPointPosixUser):
            GetAccessPointPosixUser = GetAccessPointPosixUser(
            gid = javaType.gid(),
            secondaryGids = javaType.secondaryGids().map({ args0 -> args0 }),
            uid = javaType.uid(),
        )
    }
}
